/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.projection;

import java.util.Set;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.AbstractProjection;
import org.springframework.hateoas.Link;

public class EmbedRelsProjection
extends AbstractProjection {
    public static final String NAME = "embedrels";
    private final Set<String> embedRels;

    public EmbedRelsProjection(Set<String> embedRels) {
        this.embedRels = embedRels;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean allowEmbedding(HALResource<? extends RestAddressableModel> halResource, LinkRest linkRest, Link ... oldLinks) {
        if (((RestAddressableModel)halResource.getContent()).getEmbedLevel() == 0 && this.embedRels.contains(linkRest.name())) {
            return true;
        }
        StringBuilder fullName = new StringBuilder();
        for (Link oldLink : oldLinks) {
            fullName.append(oldLink.getRel().value()).append("/");
        }
        fullName.append(linkRest.name());
        if (this.embedRels.contains(fullName.toString())) {
            return true;
        }
        fullName.append("/");
        for (String embedRel : this.embedRels) {
            if (!embedRel.startsWith(fullName.toString())) continue;
            return true;
        }
        return false;
    }
}

