/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.StatisticsSupportRest;
import org.dspace.app.rest.model.UsageReportRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.DSpaceObjectUtils;
import org.dspace.app.rest.utils.UsageReportUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="statistics.usagereport")
public class StatisticsRestRepository
extends DSpaceRestRepository<UsageReportRest, String> {
    @Autowired
    private DSpaceObjectUtils dspaceObjectUtil;
    @Autowired
    private UsageReportUtils usageReportUtils;

    public StatisticsSupportRest getStatisticsSupport() {
        return new StatisticsSupportRest();
    }

    @Override
    @PreAuthorize(value="hasPermission(#uuidObjectReportId, 'usagereport', 'READ')")
    public UsageReportRest findOne(Context context, String uuidObjectReportId) {
        UUID uuidObject = UUID.fromString(StringUtils.substringBefore((String)uuidObjectReportId, (String)"_"));
        String reportId = StringUtils.substringAfter((String)uuidObjectReportId, (String)"_");
        UsageReportRest usageReportRest = null;
        try {
            DSpaceObject dso = this.dspaceObjectUtil.findDSpaceObject(context, uuidObject);
            if (dso == null) {
                throw new IllegalArgumentException("No DSO found with uuid: " + uuidObject);
            }
            usageReportRest = this.usageReportUtils.createUsageReport(context, dso, reportId);
        }
        catch (IOException | SQLException | ParseException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (UsageReportRest)this.converter.toRest(usageReportRest, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasPermission(#uri, 'usagereportsearch', 'READ')")
    @SearchRestMethod(name="object")
    public Page<UsageReportRest> findByObject(@Parameter(value="uri", required=true) String uri, Pageable pageable) {
        UUID uuid = UUID.fromString(StringUtils.substringAfterLast((String)uri, (String)"/"));
        List<UsageReportRest> usageReportsOfItem = null;
        try {
            Context context = this.obtainContext();
            DSpaceObject dso = this.dspaceObjectUtil.findDSpaceObject(context, uuid);
            if (dso == null) {
                throw new IllegalArgumentException("No DSO found with uuid: " + uuid);
            }
            usageReportsOfItem = this.usageReportUtils.getUsageReportsOfDSO(context, dso);
        }
        catch (IOException | SQLException | ParseException | SolrServerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.converter.toRestPage(usageReportsOfItem, pageable, usageReportsOfItem.size(), this.utils.obtainProjection());
    }

    @Override
    public Page<UsageReportRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "findAll");
    }

    @Override
    public Class<UsageReportRest> getDomainClass() {
        return UsageReportRest.class;
    }
}

