/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.MoveOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.DSpaceObjectMetadataPatchUtils;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DSpaceObjectMetadataMoveOperation<R extends DSpaceObject>
extends PatchOperation<R> {
    @Autowired
    DSpaceObjectMetadataPatchUtils metadataPatchUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) throws SQLException {
        DSpaceObjectService dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(resource);
        MetadataField metadataField = this.metadataPatchUtils.getMetadataField(context, operation);
        String indexInPath = this.metadataPatchUtils.getIndexFromPath(operation.getPath());
        String indexToMoveFrom = this.metadataPatchUtils.getIndexFromPath(((MoveOperation)operation).getFrom());
        this.move(context, (DSpaceObject)resource, dsoService, metadataField, indexInPath, indexToMoveFrom);
        return resource;
    }

    private void move(Context context, DSpaceObject dso, DSpaceObjectService dsoService, MetadataField metadataField, String indexFrom, String indexTo) {
        this.metadataPatchUtils.checkMetadataFieldNotNull(metadataField);
        try {
            dsoService.moveMetadata(context, dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), Integer.parseInt(indexFrom), Integer.parseInt(indexTo));
        }
        catch (SQLException e) {
            throw new DSpaceBadRequestException("SQLException in DspaceObjectMetadataMoveOperation.move trying to move metadata in dso.", e);
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return operation.getPath().startsWith("/metadata") && operation.getOp().trim().equalsIgnoreCase("move") && objectToMatch instanceof DSpaceObject;
    }
}

