/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import java.text.ParseException;
import java.util.Date;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.resourcePolicy.ResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyStartDateAddOperation<R>
extends PatchOperation<R> {
    @Autowired
    ResourcePolicyUtils resourcePolicyUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.checkResourcePolicyForNotExistingStartDateValue(resourcePolicy);
            this.resourcePolicyUtils.checkResourcePolicyForConsistentStartDateValue(resourcePolicy, operation);
            this.add(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void add(ResourcePolicy resourcePolicy, Operation operation) {
        String dateS = (String)operation.getValue();
        try {
            Date date = ResourcePolicyUtils.simpleDateFormat.parse(dateS);
            resourcePolicy.setStartDate(date);
        }
        catch (ParseException e) {
            throw new DSpaceBadRequestException("Invalid startDate value", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!(objectToMatch instanceof ResourcePolicy)) return false;
        if (!operation.getOp().trim().equalsIgnoreCase("add")) return false;
        if (!operation.getPath().trim().equalsIgnoreCase("/startDate")) return false;
        return true;
    }

    void checkResourcePolicyForNotExistingStartDateValue(ResourcePolicy resource) {
        if (resource.getStartDate() != null) {
            throw new DSpaceBadRequestException("Attempting to add a value to an already existing path.");
        }
    }
}

