/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.sql.SQLException;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorizeServiceRestUtil {
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;
    @Autowired
    private ContentServiceFactory contentServiceFactory;

    public boolean authorizeActionBoolean(Context context, BaseObjectRest object, DSpaceRestPermission dSpaceRestPermission) throws SQLException {
        DSpaceObject dSpaceObject = (DSpaceObject)this.utils.getDSpaceAPIObjectFromRest(context, object);
        if (dSpaceObject == null) {
            return false;
        }
        DSpaceObjectService dSpaceObjectService = this.contentServiceFactory.getDSpaceObjectService(dSpaceObject.getType());
        EPerson ePerson = context.getCurrentUser();
        if (dSpaceObject instanceof Item && !DSpaceRestPermission.READ.equals((Object)dSpaceRestPermission) && !((Item)dSpaceObject).isArchived() && !((Item)dSpaceObject).isWithdrawn()) {
            return false;
        }
        return this.authorizeService.authorizeActionBoolean(context, ePerson, dSpaceObject, dSpaceRestPermission.getDspaceApiActionId(), true);
    }
}

