/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CheckSumRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitstreamConverter
extends DSpaceObjectConverter<Bitstream, BitstreamRest> {
    @Autowired
    ConverterService converter;

    public BitstreamRest convert(Bitstream obj, Projection projection) {
        BitstreamRest b = (BitstreamRest)super.convert((DSpaceObject)obj, projection);
        b.setSequenceId(Integer.valueOf(obj.getSequenceID()));
        List bundles = null;
        try {
            bundles = obj.getBundles();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        if (bundles != null && bundles.size() > 0) {
            b.setBundleName(((Bundle)bundles.get(0)).getName());
        }
        CheckSumRest checksum = new CheckSumRest();
        checksum.setCheckSumAlgorithm(obj.getChecksumAlgorithm());
        checksum.setValue(obj.getChecksum());
        b.setCheckSum(checksum);
        b.setSizeBytes(Long.valueOf(obj.getSizeBytes()));
        return b;
    }

    protected BitstreamRest newInstance() {
        return new BitstreamRest();
    }

    public Class<Bitstream> getModelClass() {
        return Bitstream.class;
    }
}

