/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.BitstreamFormatRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.service.BitstreamFormatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitstreamFormatConverter
implements DSpaceConverter<BitstreamFormat, BitstreamFormatRest> {
    @Autowired
    BitstreamFormatService bitstreamFormatService;

    public BitstreamFormatRest convert(BitstreamFormat obj, Projection projection) {
        BitstreamFormatRest bf = new BitstreamFormatRest();
        bf.setProjection(projection);
        bf.setId((Serializable)obj.getID());
        bf.setShortDescription(obj.getShortDescription());
        bf.setDescription(obj.getDescription());
        bf.setMimetype(obj.getMIMEType());
        bf.setInternal(obj.isInternal());
        if (obj.getSupportLevel() > 0) {
            bf.setSupportLevel(this.bitstreamFormatService.getSupportLevelText(obj));
        } else {
            bf.setSupportLevel("UNKNOWN");
        }
        bf.setExtensions(obj.getExtensions());
        return bf;
    }

    public Class<BitstreamFormat> getModelClass() {
        return BitstreamFormat.class;
    }
}

