/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDSpaceRestRepository {
    @Autowired
    protected Utils utils;
    @Autowired
    protected ConverterService converter;
    protected RequestService requestService = new DSpace().getRequestService();

    protected Context obtainContext() {
        Context context = null;
        Request currentRequest = this.requestService.getCurrentRequest();
        context = ContextUtil.obtainContext((ServletRequest)currentRequest.getServletRequest());
        Locale currentLocale = this.getLocale(context, currentRequest);
        context.setCurrentLocale(currentLocale);
        return context;
    }

    public RequestService getRequestService() {
        return this.requestService;
    }

    private Locale getLocale(Context context, Request request) {
        String userLanguage;
        Enumeration locales;
        Locale userLocale = null;
        Locale supportedLocale = null;
        String locale = request.getHttpServletRequest().getHeader("Accept-Language");
        if (StringUtils.isNotBlank((CharSequence)locale) && (locales = request.getHttpServletRequest().getLocales()) != null) {
            while (locales.hasMoreElements()) {
                Locale current = (Locale)locales.nextElement();
                if (!I18nUtil.isSupportedLocale((Locale)current)) continue;
                userLocale = current;
                break;
            }
        }
        if (userLocale == null && context.getCurrentUser() != null && (userLanguage = context.getCurrentUser().getLanguage()) != null) {
            userLocale = new Locale(userLanguage);
        }
        if (userLocale == null) {
            return I18nUtil.getDefaultLocale();
        }
        supportedLocale = I18nUtil.getSupportedLocale(userLocale);
        return supportedLocale;
    }
}

