/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.model.EntityTypeRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.entitytype")
public class EntityTypeRestRepository
extends DSpaceRestRepository<EntityTypeRest, Integer> {
    @Autowired
    private EntityTypeService entityTypeService;

    @PreAuthorize(value="permitAll()")
    public EntityTypeRest findOne(Context context, Integer integer) {
        try {
            EntityType entityType = (EntityType)this.entityTypeService.find(context, integer.intValue());
            if (entityType == null) {
                throw new ResourceNotFoundException("The entityType for ID: " + integer + " could not be found");
            }
            return (EntityTypeRest)this.converter.toRest((Object)entityType, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Page<EntityTypeRest> findAll(Context context, Pageable pageable) {
        try {
            List entityTypes = this.entityTypeService.findAll(context);
            return this.converter.toRestPage(entityTypes, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<EntityTypeRest> getDomainClass() {
        return EntityTypeRest.class;
    }
}

