/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item.relationships")
public class ItemRelationshipLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    RelationshipService relationshipService;
    @Autowired
    ItemService itemService;

    @PreAuthorize(value="hasPermission(#itemId, 'ITEM', 'READ')")
    public Page<RelationshipRest> getRelationships(@Nullable HttpServletRequest request, UUID itemId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemId);
            if (item == null) {
                throw new ResourceNotFoundException("No such item: " + itemId);
            }
            int total = this.relationshipService.countByItem(context, item);
            Pageable pageable = this.utils.getPageable(optionalPageable);
            List relationships = this.relationshipService.findByItem(context, item, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(relationships, pageable, (long)total, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

