/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.process.output")
public class ProcessOutputLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ProcessService processService;
    @Autowired
    private AuthorizeService authorizeService;

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public BitstreamRest getOutputFromProcess(@Nullable HttpServletRequest request, Integer processId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.processService.find(context, processId.intValue());
        if (context.getCurrentUser() == null || !context.getCurrentUser().equals((Object)process.getEPerson()) && !this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("The current user is not eligible to view the process with id: " + processId);
        }
        Bitstream bitstream = this.processService.getBitstream(context, process, "script_output");
        if (bitstream == null) {
            return null;
        }
        return (BitstreamRest)this.converter.toRest((Object)bitstream, projection);
    }
}

