/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import org.dspace.app.rest.model.SubmissionCCLicenseRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.license.CCLicense;
import org.dspace.license.service.CreativeCommonsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissioncclicense")
public class SubmissionCCLicenseRestRepository
extends DSpaceRestRepository<SubmissionCCLicenseRest, String> {
    @Autowired
    protected CreativeCommonsService creativeCommonsService;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionCCLicenseRest findOne(Context context, String licenseId) {
        CCLicense ccLicense = this.creativeCommonsService.findOne(licenseId);
        if (ccLicense == null) {
            throw new ResourceNotFoundException("No CC license could be found for ID: " + licenseId);
        }
        return (SubmissionCCLicenseRest)this.converter.toRest((Object)ccLicense, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionCCLicenseRest> findAll(Context context, Pageable pageable) {
        List allCCLicenses = this.creativeCommonsService.findAllCCLicenses();
        return this.converter.toRestPage(allCCLicenses, pageable, this.utils.obtainProjection());
    }

    public Class<SubmissionCCLicenseRest> getDomainClass() {
        return SubmissionCCLicenseRest.class;
    }
}

