/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.AccessConditionOptionRest;
import org.dspace.app.rest.model.SubmissionUploadRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.app.rest.utils.DateMathParser;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.submit.model.AccessConditionOption;
import org.dspace.submit.model.UploadConfiguration;
import org.dspace.submit.model.UploadConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionupload")
public class SubmissionUploadRestRepository
extends DSpaceRestRepository<SubmissionUploadRest, String> {
    private static final Logger log = LogManager.getLogger(SubmissionUploadRestRepository.class);
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;
    @Autowired
    private UploadConfigurationService uploadConfigurationService;
    @Autowired
    GroupService groupService;
    DateMathParser dateMathParser = new DateMathParser();

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionUploadRest findOne(Context context, String submitName) {
        UploadConfiguration config = (UploadConfiguration)this.uploadConfigurationService.getMap().get(submitName);
        try {
            return this.convert(context, config, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionUploadRest> findAll(Context context, Pageable pageable) {
        Collection uploadConfigs = this.uploadConfigurationService.getMap().values();
        Projection projection = this.utils.obtainProjection();
        ArrayList<SubmissionUploadRest> results = new ArrayList<SubmissionUploadRest>();
        ArrayList<String> configNames = new ArrayList<String>();
        for (UploadConfiguration uploadConfig : uploadConfigs) {
            if (configNames.contains(uploadConfig.getName())) continue;
            configNames.add(uploadConfig.getName());
            try {
                results.add(this.convert(context, uploadConfig, projection));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.utils.getPage(results, pageable);
    }

    public Class<SubmissionUploadRest> getDomainClass() {
        return SubmissionUploadRest.class;
    }

    private SubmissionUploadRest convert(Context context, UploadConfiguration config, Projection projection) {
        SubmissionUploadRest result = new SubmissionUploadRest();
        result.setProjection(projection);
        for (AccessConditionOption option : config.getOptions()) {
            Group group;
            AccessConditionOptionRest optionRest = new AccessConditionOptionRest();
            if (option.getGroupName() != null) {
                try {
                    group = this.groupService.findByName(context, option.getGroupName());
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Wrong group name configuration for the access condition option named " + option.getName());
                }
                if (group != null) {
                    optionRest.setGroupUUID(group.getID());
                }
            }
            if (option.getSelectGroupName() != null) {
                try {
                    group = this.groupService.findByName(context, option.getSelectGroupName());
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Wrong select group name configuration for the access condition option named " + option.getName());
                }
                if (group != null) {
                    optionRest.setSelectGroupUUID(group.getID());
                }
            }
            optionRest.setHasStartDate(option.getHasStartDate());
            optionRest.setHasEndDate(option.getHasEndDate());
            if (StringUtils.isNotBlank((CharSequence)option.getStartDateLimit())) {
                try {
                    optionRest.setMaxStartDate(this.dateMathParser.parseMath(option.getStartDateLimit()));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong start date limit configuration for the access condition option named  " + option.getName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)option.getEndDateLimit())) {
                try {
                    optionRest.setMaxEndDate(this.dateMathParser.parseMath(option.getEndDateLimit()));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Wrong end date limit configuration for the access condition option named  " + option.getName());
                }
            }
            optionRest.setName(option.getName());
            result.getAccessConditionOptions().add(optionRest);
        }
        result.setMetadata(this.submissionFormRestRepository.findOne(context, config.getMetadata()));
        result.setMaxSize(config.getMaxSize());
        result.setRequired(config.isRequired().booleanValue());
        result.setName(config.getName());
        return result;
    }
}

