/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.VersionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="versioning.versionhistory.versions")
public class VersionsLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private VersioningService versioningService;

    public Page<VersionRest> getVersions(@Nullable HttpServletRequest request, Integer versionHistoryId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = this.obtainContext();
        VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, versionHistoryId.intValue());
        if (versionHistory == null) {
            throw new ResourceNotFoundException("The versionHistory with ID: " + versionHistoryId + " couldn't be found");
        }
        List versions = this.versioningService.getVersionsByHistory(context, versionHistory);
        Pageable pageable = optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
        return this.converter.toRestPage(versions, pageable, projection);
    }
}

