/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.resourcePolicy.ResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyNameAddOperation<R>
extends PatchOperation<R> {
    @Autowired
    ResourcePolicyUtils resourcePolicyUtils;

    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.checkModelForNotExistingValue(resourcePolicy);
            this.add(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    public void add(ResourcePolicy resourcePolicy, Operation operation) {
        String name = (String)operation.getValue();
        resourcePolicy.setRpName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!(objectToMatch instanceof ResourcePolicy)) return false;
        if (!operation.getOp().trim().equalsIgnoreCase("add")) return false;
        if (!operation.getPath().trim().equalsIgnoreCase("/name")) return false;
        return true;
    }

    private void checkModelForNotExistingValue(ResourcePolicy resource) {
        if (resource.getRpName() != null) {
            throw new DSpaceBadRequestException("Attempting to add a value to an already existing path.");
        }
    }
}

