/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.authorize.ResourcePolicy;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyUtils {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final String OPERATION_PATH_STARTDATE = "/startDate";
    public static final String OPERATION_PATH_ENDDATE = "/endDate";
    public static final String OPERATION_PATH_DESCRIPTION = "/description";
    public static final String OPERATION_PATH_NAME = "/name";

    public void checkResourcePolicyForExistingStartDateValue(ResourcePolicy resource, Operation operation) {
        if (resource.getStartDate() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent start date value.");
        }
    }

    public void checkResourcePolicyForExistingEndDateValue(ResourcePolicy resource, Operation operation) {
        if (resource.getEndDate() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent end date value.");
        }
    }

    public void checkResourcePolicyForExistingNameValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpName() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent name value.");
        }
    }

    public void checkResourcePolicyForExistingDescriptionValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpDescription() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent description value.");
        }
    }

    public void checkResourcePolicyForConsistentStartDateValue(ResourcePolicy resource, Operation operation) {
        String dateS = (String)operation.getValue();
        try {
            Date date = simpleDateFormat.parse(dateS);
            if (resource.getEndDate() != null && resource.getEndDate().before(date)) {
                throw new DSpaceBadRequestException("Attempting to set an invalid startDate greater than the endDate.");
            }
        }
        catch (ParseException e) {
            throw new DSpaceBadRequestException("Invalid startDate value", (Exception)e);
        }
    }

    public void checkResourcePolicyForConsistentEndDateValue(ResourcePolicy resource, Operation operation) {
        String dateS = (String)operation.getValue();
        try {
            Date date = simpleDateFormat.parse(dateS);
            if (resource.getEndDate() != null && resource.getStartDate().after(date)) {
                throw new DSpaceBadRequestException("Attempting to set an invalid endDate smaller than the startDate.");
            }
        }
        catch (ParseException e) {
            throw new DSpaceBadRequestException("Invalid endDate value", (Exception)e);
        }
    }
}

