/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class WorkflowRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(WorkflowRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private XmlWorkflowItemService workflowItemService;
    @Autowired
    private PoolTaskService poolTaskService;
    @Autowired
    private ClaimedTaskService claimedTaskService;
    @Autowired
    private EPersonService ePersonService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)"workflowitem", (CharSequence)targetType)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((ServletRequest)request.getServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            if (ePerson == null) {
                return false;
            }
            Integer dsoId = Integer.parseInt(targetId.toString());
            XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.workflowItemService.find(context, dsoId.intValue());
            if (ePerson.equals((Object)workflowItem.getSubmitter())) {
                return true;
            }
            if (this.poolTaskService.findByWorkflowIdAndEPerson(context, workflowItem, ePerson) != null) {
                return true;
            }
            if (this.claimedTaskService.findByWorkflowIdAndEPerson(context, workflowItem, ePerson) != null) {
                return true;
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }
}

