/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class WorkspaceItemRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceItemRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    WorkspaceItemService wis;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!(DSpaceRestPermission.READ.equals((Object)restPermission) || DSpaceRestPermission.WRITE.equals((Object)restPermission) || DSpaceRestPermission.DELETE.equals((Object)restPermission))) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"workspaceitem")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((ServletRequest)request.getServletRequest());
        EPerson ePerson = null;
        WorkspaceItem witem = null;
        try {
            ePerson = context.getCurrentUser();
            Integer dsoId = Integer.parseInt(targetId.toString());
            if (ePerson == null) {
                return false;
            }
            witem = this.wis.find(context, dsoId.intValue());
            if (witem == null) {
                return true;
            }
            if (witem.getSubmitter() != null && witem.getSubmitter().getID().equals(ePerson.getID())) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

