/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

@Configuration
@EnableSpringDataWebSupport
@ComponentScan(value={"org.dspace.app.rest.converter", "org.dspace.app.rest.repository", "org.dspace.app.rest.utils", "org.dspace.app.configuration"})
public class ApplicationConfig {
    @Value(value="${rest.cors.allowed-origins}")
    private String[] corsAllowedOrigins;
    @Value(value="${rest.cors.allow-credentials:true}")
    private boolean corsAllowCredentials;
    @Value(value="${dspace.ui.url:http://localhost:4000}")
    private String uiURL;

    public String[] getCorsAllowedOrigins() {
        if (this.corsAllowedOrigins != null) {
            return this.corsAllowedOrigins;
        }
        if (this.uiURL != null) {
            return new String[]{this.uiURL};
        }
        return null;
    }

    public boolean getCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }
}

