/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.hateoas.BitstreamResource;
import org.dspace.app.rest.repository.BundleRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.Bundle;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/core/bundles//{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/bitstreams"})
public class BundleUploadBitstreamController {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    protected Utils utils;
    @Autowired
    private BundleService bundleService;
    @Autowired
    private BundleRestRepository bundleRestRepository;
    @Autowired
    private ConverterService converter;

    @RequestMapping(method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    @PreAuthorize(value="hasPermission(#uuid, 'BUNDLE', 'ADD') && hasPermission(#uuid, 'BUNDLE', 'WRITE')")
    public ResponseEntity<RepresentationModel<?>> uploadBitstream(HttpServletRequest request, @PathVariable UUID uuid, @RequestParam(value="file") MultipartFile uploadfile, @RequestParam(value="properties", required=false) String properties) {
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        Bundle bundle = null;
        try {
            bundle = (Bundle)this.bundleService.find(context, uuid);
        }
        catch (SQLException e) {
            log.error("Something went wrong trying to find the Bundle with uuid: " + uuid, (Throwable)e);
        }
        if (bundle == null) {
            throw new ResourceNotFoundException("The given uuid did not resolve to a Bundle on the server: " + uuid);
        }
        InputStream fileInputStream = null;
        try {
            fileInputStream = uploadfile.getInputStream();
        }
        catch (IOException e) {
            log.error("Something went wrong when trying to read the inputstream from the given file in the request", (Throwable)e);
            throw new UnprocessableEntityException("The InputStream from the file couldn't be read", e);
        }
        BitstreamRest bitstreamRest = this.bundleRestRepository.uploadBitstream(context, bundle, uploadfile.getOriginalFilename(), fileInputStream, properties);
        BitstreamResource bitstreamResource = (BitstreamResource)((Object)this.converter.toResource(bitstreamRest));
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)bitstreamResource);
    }
}

