/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.IdentifierService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pid"})
public class IdentifierRestController
implements InitializingBean {
    public static final String CATEGORY = "pid";
    public static final String ACTION = "find";
    public static final String PARAM = "id";
    private static final Logger log = Logger.getLogger(IdentifierRestController.class);
    @Autowired
    private ConverterService converter;
    @Autowired
    private Utils utils;
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register(this, Arrays.asList(new Link(new UriTemplate("/api/pid/find", new TemplateVariables(new TemplateVariable[]{new TemplateVariable(PARAM, TemplateVariable.VariableType.REQUEST_PARAM)})), CATEGORY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"find"}, params={"id"})
    public void getDSObyIdentifier(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") String id) throws IOException, SQLException {
        DSpaceObject dso = null;
        Context context = ContextUtil.obtainContext((ServletRequest)request);
        IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
        try {
            dso = identifierService.resolve(context, id);
            if (dso != null) {
                DSpaceObjectRest dsor = (DSpaceObjectRest)this.converter.toRest(dso, this.utils.obtainProjection());
                URI link = ((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo((Class)dsor.getController(), (Object[])new Object[]{dsor.getCategory(), English.plural((String)dsor.getType())}).slash((Object)dsor.getId())).toUri();
                response.setStatus(302);
                response.sendRedirect(link.toString());
            } else {
                response.setStatus(404);
            }
        }
        catch (IdentifierNotFoundException e) {
            response.setStatus(404);
        }
        catch (IdentifierNotResolvableException e) {
            response.setStatus(501);
        }
        finally {
            context.abort();
        }
    }
}

