/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.dspace.app.rest.converter.PatchConverter;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.CopyOperation;
import org.dspace.app.rest.model.patch.FromOperation;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.MoveOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.springframework.data.rest.webmvc.json.patch.PatchException;

public class JsonPatchConverter
implements PatchConverter<JsonNode> {
    @Nonnull
    private final ObjectMapper mapper;

    public JsonPatchConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Patch convert(JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            throw new IllegalArgumentException("JsonNode must be an instance of ArrayNode");
        }
        ArrayNode opNodes = (ArrayNode)jsonNode;
        ArrayList<Operation> ops = new ArrayList<Operation>(opNodes.size());
        Iterator elements = opNodes.elements();
        while (elements.hasNext()) {
            String from;
            JsonNode opNode = (JsonNode)elements.next();
            String opType = opNode.get("op").textValue();
            String path = opNode.get("path").textValue();
            JsonNode valueNode = opNode.get("value");
            Object value = this.valueFromJsonNode(path, valueNode);
            String string = from = opNode.has("from") ? opNode.get("from").textValue() : null;
            if (opType.equals("replace")) {
                ops.add(new ReplaceOperation(path, value));
                continue;
            }
            if (opType.equals("remove")) {
                ops.add(new RemoveOperation(path));
                continue;
            }
            if (opType.equals("add")) {
                ops.add(new AddOperation(path, value));
                continue;
            }
            if (opType.equals("copy")) {
                ops.add(new CopyOperation(path, from));
                continue;
            }
            if (opType.equals("move")) {
                ops.add(new MoveOperation(path, from));
                continue;
            }
            throw new PatchException("Unrecognized operation type: " + opType);
        }
        return new Patch(ops);
    }

    @Override
    public JsonNode convert(Patch patch) {
        List<Operation> operations = patch.getOperations();
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ArrayNode patchNode = nodeFactory.arrayNode();
        for (Operation operation : operations) {
            Object value;
            ObjectNode opNode = nodeFactory.objectNode();
            opNode.set("op", (JsonNode)nodeFactory.textNode(operation.getOp()));
            opNode.set("path", (JsonNode)nodeFactory.textNode(operation.getPath()));
            if (operation instanceof FromOperation) {
                FromOperation fromOp = (FromOperation)operation;
                opNode.set("from", (JsonNode)nodeFactory.textNode(fromOp.getFrom()));
            }
            if ((value = operation.getValue()) != null) {
                opNode.set("value", value instanceof JsonValueEvaluator ? ((JsonValueEvaluator)value).getValueNode() : this.mapper.valueToTree(value));
            }
            patchNode.add((JsonNode)opNode);
        }
        return patchNode;
    }

    private Object valueFromJsonNode(String path, JsonNode valueNode) {
        if (valueNode == null || valueNode.isNull()) {
            return null;
        }
        if (valueNode.isTextual()) {
            return valueNode.asText();
        }
        if (valueNode.isFloatingPointNumber()) {
            return valueNode.asDouble();
        }
        if (valueNode.isBoolean()) {
            return valueNode.asBoolean();
        }
        if (valueNode.isInt()) {
            return valueNode.asInt();
        }
        if (valueNode.isLong()) {
            return valueNode.asLong();
        }
        if (valueNode.isObject() || valueNode.isArray()) {
            return new JsonValueEvaluator(this.mapper, valueNode);
        }
        throw new PatchException(String.format("Unrecognized valueNode type at path %s and value node %s.", path, valueNode));
    }
}

