/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bundle")
public class BundleRestRepository
extends DSpaceObjectRestRepository<Bundle, BundleRest> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private BundleService bundleService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;

    public BundleRestRepository(BundleService dsoService) {
        super(dsoService);
        this.bundleService = dsoService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'BUNDLE', 'READ')")
    public BundleRest findOne(Context context, UUID id) {
        Bundle bundle = null;
        try {
            bundle = (Bundle)this.bundleService.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bundle == null) {
            return null;
        }
        return (BundleRest)this.converter.toRest(bundle, this.utils.obtainProjection());
    }

    @Override
    public Page<BundleRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("bundle", "findAll");
    }

    @Override
    @PreAuthorize(value="hasPermission(#uuid, 'BUNDLE', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID uuid, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, uuid, patch);
    }

    public BitstreamRest uploadBitstream(Context context, Bundle bundle, String fileName, InputStream fileInputStream, String properties) {
        Item item = null;
        Bitstream bitstream = null;
        try {
            List items = bundle.getItems();
            if (!items.isEmpty()) {
                item = (Item)items.get(0);
            }
            if (!(item == null || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1) && this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 3))) {
                throw new AccessDeniedException("You do not have write rights to update the Bundle's item");
            }
            bitstream = this.processBitstreamCreation(context, bundle, fileInputStream, properties, fileName);
            if (item != null) {
                this.itemService.update(context, (DSpaceObject)item);
            }
            this.bundleService.update(context, (DSpaceObject)bundle);
            context.commit();
        }
        catch (IOException | SQLException | AuthorizeException e) {
            String message = "Something went wrong with trying to create the single bitstream for file with filename: " + fileName + " for item with uuid: " + bundle.getID() + " and possible properties: " + properties;
            log.error(message, e);
            throw new RuntimeException(message, e);
        }
        return (BitstreamRest)this.converter.toRest(bitstream, this.utils.obtainProjection());
    }

    private Bitstream processBitstreamCreation(Context context, Bundle bundle, InputStream fileInputStream, String properties, String originalFilename) throws AuthorizeException, IOException, SQLException {
        Bitstream bitstream = null;
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            String name;
            ObjectMapper mapper = new ObjectMapper();
            BitstreamRest bitstreamRest = null;
            try {
                bitstreamRest = (BitstreamRest)mapper.readValue(properties, BitstreamRest.class);
            }
            catch (Exception e) {
                throw new UnprocessableEntityException("The properties parameter was incorrect: " + properties);
            }
            bitstream = this.bitstreamService.create(context, bundle, fileInputStream);
            if (bitstreamRest.getMetadata() != null) {
                this.metadataConverter.setMetadata(context, (DSpaceObject)bitstream, bitstreamRest.getMetadata());
            }
            if (StringUtils.isNotBlank((CharSequence)(name = bitstreamRest.getName()))) {
                bitstream.setName(context, name);
            } else {
                bitstream.setName(context, originalFilename);
            }
        } else {
            bitstream = this.bitstreamService.create(context, bundle, fileInputStream);
            bitstream.setName(context, originalFilename);
        }
        BitstreamFormat bitstreamFormat = this.bitstreamFormatService.guessFormat(context, bitstream);
        this.bitstreamService.setFormat(context, bitstream, bitstreamFormat);
        this.bitstreamService.update(context, (DSpaceObject)bitstream);
        return bitstream;
    }

    @Override
    public Class<BundleRest> getDomainClass() {
        return BundleRest.class;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'BUNDLE', 'DELETE')")
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Bundle bundleToDelete = null;
        try {
            bundleToDelete = (Bundle)this.bundleService.find(context, id);
            if (bundleToDelete == null) {
                throw new ResourceNotFoundException("Bundle with id: " + id + " not found");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't find a bundle with id: " + id, e);
        }
        try {
            this.bundleService.delete(context, (DSpaceObject)bundleToDelete);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Something went wrong trying to delete bundle with id: " + id, e);
        }
    }
}

