/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AdminRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(RestObjectPermissionEvaluatorPlugin.class);
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private EPersonService ePersonService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            if (ePerson != null && this.authorizeService.isAdmin(context, ePerson)) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

