/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class GroupRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(GroupRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    AuthorizeService authorizeService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission) || Constants.getTypeID((String)targetType) != 6) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            UUID dsoId = UUID.fromString(targetId.toString());
            Group group = (Group)this.groupService.find(context, dsoId);
            if (ePerson == null) {
                return false;
            }
            if (this.groupService.isMember(context, ePerson, group)) {
                return true;
            }
            if (this.authorizeService.isCommunityAdmin(context, ePerson) && AuthorizeUtil.canCommunityAdminManageAccounts()) {
                return true;
            }
            if (this.authorizeService.isCollectionAdmin(context, ePerson) && AuthorizeUtil.canCollectionAdminManageAccounts()) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

