/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class StatelessLoginFilter
extends AbstractAuthenticationProcessingFilter {
    protected AuthenticationManager authenticationManager;
    protected RestAuthenticationService restAuthenticationService;

    public void afterPropertiesSet() {
    }

    public StatelessLoginFilter(String url, AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService) {
        super((RequestMatcher)new AntPathRequestMatcher(url));
        this.authenticationManager = authenticationManager;
        this.restAuthenticationService = restAuthenticationService;
    }

    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        String user = req.getParameter("user");
        String password = req.getParameter("password");
        return this.authenticationManager.authenticate((Authentication)new DSpaceAuthentication(user, password, new ArrayList<GrantedAuthority>()));
    }

    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        DSpaceAuthentication dSpaceAuthentication = (DSpaceAuthentication)auth;
        this.restAuthenticationService.addAuthenticationDataForUser(req, res, dSpaceAuthentication, false);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        String authenticateHeaderValue = this.restAuthenticationService.getWwwAuthenticateHeaderValue(request, response);
        response.setHeader("WWW-Authenticate", authenticateHeaderValue);
        response.sendError(401, failed.getMessage());
    }
}

