/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataUpload;
import org.dspace.app.rest.model.step.UploadBitstreamRest;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.rest.submit.factory.PatchOperationFactory;
import org.dspace.app.rest.submit.factory.impl.PatchOperation;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.model.Request;
import org.springframework.web.multipart.MultipartFile;

public class UploadStep
extends org.dspace.submit.step.UploadStep
implements AbstractRestProcessingStep,
UploadableStep {
    private static final Logger log = LogManager.getLogger(UploadStep.class);
    public static final String UPLOAD_STEP_METADATA_SECTION = "bitstream-metadata";

    public DataUpload getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        DataUpload result = new DataUpload();
        List bundles = this.itemService.getBundles(obj.getItem(), "ORIGINAL");
        for (Bundle bundle : bundles) {
            for (Bitstream source : bundle.getBitstreams()) {
                UploadBitstreamRest b = submissionService.buildUploadBitstream(this.configurationService, source);
                result.getFiles().add(b);
            }
        }
        return result;
    }

    @Override
    public void doPatchProcessing(Context context, Request currentRequest, InProgressSubmission source, Operation op, SubmissionStepConfig stepConf) throws Exception {
        String instance = null;
        if ("remove".equals(op.getOp())) {
            instance = op.getPath().contains("metadata") ? "bitstreammetadata" : (op.getPath().contains("accessConditions") ? "accessConditions" : "bitstreamremove");
        } else if ("move".equals(op.getOp())) {
            instance = op.getPath().contains("metadata") ? "bitstreammetadata" : "bitstreammove";
        } else if (op.getPath().contains("accessConditions")) {
            instance = "accessConditions";
        } else if (op.getPath().contains("metadata")) {
            instance = "bitstreammetadata";
        }
        if (instance == null) {
            throw new UnprocessableEntityException("The path " + op.getPath() + " is not supported by the operation " + op.getOp());
        }
        PatchOperation patchOperation = new PatchOperationFactory().instanceOf(instance, op.getOp());
        patchOperation.perform(context, currentRequest, source, op);
    }

    @Override
    public ErrorRest upload(Context context, SubmissionService submissionService, SubmissionStepConfig stepConfig, InProgressSubmission wsi, MultipartFile file) {
        Bitstream source = null;
        BitstreamFormat bf = null;
        Item item = wsi.getItem();
        List bundles = null;
        try {
            bundles = this.itemService.getBundles(item, "ORIGINAL");
            BufferedInputStream inputStream = new BufferedInputStream(file.getInputStream());
            source = bundles.size() < 1 ? this.itemService.createSingleBitstream(context, (InputStream)inputStream, item, "ORIGINAL") : this.bitstreamService.create(context, (Bundle)bundles.get(0), (InputStream)inputStream);
            source.setName(context, Utils.getFileName(file));
            source.setSource(context, file.getOriginalFilename());
            bf = this.bitstreamFormatService.guessFormat(context, source);
            source.setFormat(context, bf);
            this.bitstreamService.update(context, (DSpaceObject)source);
            this.itemService.update(context, (DSpaceObject)item);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ErrorRest result = new ErrorRest();
            result.setMessage(e.getMessage());
            if (bundles != null && bundles.size() > 0) {
                result.getPaths().add("/sections/" + stepConfig.getId() + "/files/" + ((Bundle)bundles.get(0)).getBitstreams().size());
            } else {
                result.getPaths().add("/sections/" + stepConfig.getId());
            }
            return result;
        }
        return null;
    }
}

