/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AuthorizationFeatureRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authzFeatureService;

    @Test
    public void findAllTest() throws Exception {
        int featuresNum = this.authzFeatureService.findAll().size();
        int expReturn = featuresNum > 20 ? 20 : featuresNum;
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.features", (Matcher)Matchers.hasSize((Matcher)Matchers.is((Object)expReturn)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)featuresNum)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String epersonAuthToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllWithPaginationTest() throws Exception {
        int featuresNum = this.authzFeatureService.findAll().size();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        ArrayList<String> featureIDs = new ArrayList<String>();
        for (int page = 0; page < featuresNum; ++page) {
            AtomicReference idRef = new AtomicReference();
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features", (Object[])new Object[0]).param("page", new String[]{String.valueOf(page)}).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.features", (Matcher)Matchers.hasSize((Matcher)Matchers.is((Object)1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(page == 0 ? MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Object[])new Object[0]).doesNotExist() : MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(page == featuresNum - 1 ? MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist() : MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.containsString((String)"/api/authz/features"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)featuresNum))).andDo(result -> idRef.set((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.features[0].id", (Predicate[])new Predicate[0])));
            if (idRef.get() == null || featureIDs.contains(idRef.get())) {
                Assert.fail((String)("Duplicate feature " + (String)idRef.get() + " returned at page " + page));
            }
            featureIDs.add((String)idRef.get());
        }
    }

    @Test
    public void findOneTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/withdrawItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)"withdrawItem"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.description", (Matcher)Matchers.any(String.class))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.resourcetypes", (Matcher)Matchers.contains((Object[])new String[]{"core.item"}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"feature")));
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/not-existing-feature", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findByResourceTypeTest() throws Exception {
        AuthorizationFeature alwaysTrueFeature = this.authzFeatureService.find("alwaystrue");
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        for (String type : alwaysTrueFeature.getSupportedTypes()) {
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/search/resourcetype", (Object[])new Object[0]).param("type", new String[]{type})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.features", (Matcher)Matchers.everyItem((Matcher)JsonPathMatchers.hasJsonPath((String)"$.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)type))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/features/search/resourcetype")));
        }
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/search/resourcetype", (Object[])new Object[0]).param("type", new String[]{"NOT-EXISTING"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/search/resourcetype", (Object[])new Object[0]).param("type", new String[]{"core.item"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String epersonAuthToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/features/search/resourcetype", (Object[])new Object[0]).param("type", new String[]{"core.item"})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

