/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BitstreamControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    BundleService bundleService;
    @Autowired
    BitstreamService bitstreamService;
    private static final Logger log = LogManager.getLogger(BitstreamControllerIT.class);

    @Test
    public void getBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("ORIGINAL").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void getFirstBundleWhenMultipleBundles() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST SECOND BUNDLE").withBitstream(bitstream).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not(BundleMatcher.matchBundle(bundle2.getName(), bundle2.getID(), bundle2.getHandle(), bundle2.getType(), bundle2.getBitstreams()))));
    }

    @Test
    public void getBundleWhenNoBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.bundleService.removeBitstream(this.context, bundle1, bitstream);
        this.bundleService.update(this.context, (DSpaceObject)bundle1);
        this.bitstreamService.update(this.context, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void putOnBitstreamInOneBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        targetBundle = (Bundle)this.bundleService.find(this.context, targetBundle.getID());
        String name = targetBundle.getName();
        String handle = targetBundle.getHandle();
        List bitstreams = targetBundle.getBitstreams();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(name, targetBundle.getID(), handle, targetBundle.getType(), bitstreams))));
    }

    @Test
    public void putOnBitstreamInOneBundleForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2016-11-11").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2016-11-11").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void putOnBitstreamInMultipleBundles() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST SECOND BUNDLE").withBitstream(bitstream).build();
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle2).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle2).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        targetBundle = (Bundle)this.bundleService.find(this.context, targetBundle.getID());
        String name = targetBundle.getName();
        String handle = targetBundle.getHandle();
        List bitstreams = targetBundle.getBitstreams();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(name, targetBundle.getID(), handle, targetBundle.getType(), bitstreams))));
    }

    @Test
    public void putOnBitstreamInNoBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.bundleService.removeBitstream(this.context, bundle1, bitstream);
        this.bundleService.update(this.context, (DSpaceObject)bundle1);
        this.bitstreamService.update(this.context, (DSpaceObject)bitstream);
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        targetBundle = (Bundle)this.bundleService.find(this.context, targetBundle.getID());
        String name = targetBundle.getName();
        String handle = targetBundle.getHandle();
        List bitstreams = targetBundle.getBitstreams();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(name, targetBundle.getID(), handle, targetBundle.getType(), bitstreams))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoRemoveRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoWriteOnCurrentBundleRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoWriteRightsOnTargetBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoAddRightsOnTargetBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoWriteRightsOnBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoWriteRightsOnCurrentItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetItem).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }

    @Test
    public void putOnBitstreamInOneBundleWithNoWriteRightsOnTargetItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Item targetItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        Bundle bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("TEST FIRST BUNDLE").build();
        String bitstreamContent = "ThisIsSomeDummyText";
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)bundle1, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        Bundle targetBundle = BundleBuilder.createBundle((Context)this.context, (Item)targetItem).withName("TARGET BUNDLE").build();
        EPerson putBundlePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("bundle@pput.org").withPassword("test").withNameInMetadata("Bundle", "Put").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(4).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bundle1).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(3).withDspaceObject((DSpaceObject)targetBundle).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)bitstream).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(putBundlePerson).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(putBundlePerson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/bundles/" + targetBundle.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bitstream.getID() + "/bundle"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(BundleMatcher.matchBundle(bundle1.getName(), bundle1.getID(), bundle1.getHandle(), bundle1.getType(), bundle1.getBitstreams()))));
    }
}

