/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.BitstreamMatcher;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.MoveOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BundleRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    ItemService itemService;
    private Collection collection;
    private Item item;
    private Bundle bundle1;
    private Bundle bundle2;
    private Bitstream bitstream1;
    private Bitstream bitstream2;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchBundle(this.bundle1.getName(), this.bundle1.getID(), this.bundle1.getHandle(), this.bundle1.getType(), this.bundle1.getBitstreams())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchLinks(this.bundle1.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(this.bundle1.getName(), this.bundle1.getID(), this.bundle1.getHandle(), this.bundle1.getType())));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).build();
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bundle1, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getItemBundles() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).build();
        this.bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("test2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{BundleMatcher.matchBundle(this.bundle1.getName(), this.bundle1.getID(), this.bundle1.getHandle(), this.bundle1.getType(), this.bundle1.getBitstreams()), BundleMatcher.matchBundle(this.bundle2.getName(), this.bundle2.getID(), this.bundle2.getHandle(), this.bundle2.getType(), this.bundle2.getBitstreams())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/items/" + this.item.getID() + "/bundles"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBundleWithoutMetadata() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        BundleRest bundleRest = new BundleRest();
        bundleRest.setName("Create Bundle Without Metadata");
        UUID bundleUuid = null;
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        try {
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            bundleUuid = UUID.fromString(String.valueOf(map.get("uuid")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundleUuid), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchBundle("Create Bundle Without Metadata", bundleUuid, null, 1, new ArrayList<Bitstream>())));
        }
        catch (Throwable throwable) {
            BundleBuilder.deleteBundle(bundleUuid);
            throw throwable;
        }
        BundleBuilder.deleteBundle((UUID)bundleUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBundleWithMetadata() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        UUID bundleUuid = null;
        try {
            BundleRest bundleRest = new BundleRest();
            bundleRest.setName("Create Bundle Without Metadata");
            bundleRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("A description")}).put("dc.relation", new MetadataValueRest[]{new MetadataValueRest("A relation")}));
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            bundleUuid = UUID.fromString(String.valueOf(map.get("uuid")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundleUuid), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchBundle("Create Bundle Without Metadata", bundleUuid, null, 1, new ArrayList<Bitstream>()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "A description"), MetadataMatcher.matchMetadata("dc.relation", "A relation")))})));
        }
        catch (Throwable throwable) {
            BundleBuilder.deleteBundle(bundleUuid);
            throw throwable;
        }
        BundleBuilder.deleteBundle((UUID)bundleUuid);
    }

    @Test
    public void createBundleAsAnonymous() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        BundleRest bundleRest = new BundleRest();
        bundleRest.setName("Create Bundle Without Metadata");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void createBundleWithInsufficientPermissions() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        BundleRest bundleRest = new BundleRest();
        bundleRest.setName("Create Bundle Without Metadata");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBundleWithSufficientPermissions() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.context.turnOffAuthorisationSystem();
        EPerson createBundleEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("createm@bundle.org").withPassword("test").withNameInMetadata("Create", "Bundle").build();
        ResourcePolicy rp1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(createBundleEperson).withAction(3).withDspaceObject((DSpaceObject)this.item).build();
        this.context.restoreAuthSystemState();
        UUID bundleUuid = null;
        try {
            BundleRest bundleRest = new BundleRest();
            bundleRest.setName("Create Bundle Without Metadata");
            String token = this.getAuthToken(createBundleEperson.getEmail(), "test");
            MvcResult mvcResult = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + this.item.getID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
            String content = mvcResult.getResponse().getContentAsString();
            Map map = (Map)mapper.readValue(content, Map.class);
            bundleUuid = UUID.fromString(String.valueOf(map.get("uuid")));
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundleUuid), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchBundle("Create Bundle Without Metadata", bundleUuid, null, 1, new ArrayList<Bitstream>())));
        }
        catch (Throwable throwable) {
            BundleBuilder.deleteBundle(bundleUuid);
            throw throwable;
        }
        BundleBuilder.deleteBundle((UUID)bundleUuid);
    }

    @Test
    public void createBundleOnNonExistingItem() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        BundleRest bundleRest = new BundleRest();
        bundleRest.setName("Create Bundle Without Metadata");
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + UUID.randomUUID() + "/bundles"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)bundleRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getBitstreamsForBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{BitstreamMatcher.matchBitstreamEntry(this.bitstream1), BitstreamMatcher.matchBitstreamEntry(this.bitstream2)})));
    }

    @Test
    public void getBitstreamsForBundleForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bundle1, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/bitstreams"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void patchMoveBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BitstreamMatcher.matchBitstreamEntry(this.bitstream1), BitstreamMatcher.matchBitstreamEntry(this.bitstream2)})));
        ArrayList<Operation> ops = new ArrayList<Operation>();
        MoveOperation moveOperation = new MoveOperation("/_links/bitstreams/0/href", "/_links/bitstreams/1/href");
        ops.add((Operation)moveOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams", (Matcher)Matchers.contains((Matcher[])new Matcher[]{BitstreamMatcher.matchBitstreamEntry(this.bitstream2), BitstreamMatcher.matchBitstreamEntry(this.bitstream1)})));
    }

    @Test
    public void deleteBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/bitstreams"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bitstreams", (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{BitstreamMatcher.matchBitstreamEntry(this.bitstream1), BitstreamMatcher.matchBitstreamEntry(this.bitstream2)})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + this.bitstream2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteBundle_Forbidden() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void deleteBundle_NoAuthToken() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
        }
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").withBitstream(this.bitstream1).withBitstream(this.bitstream2).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getEmbeddedItemForBundle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "?embed=item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.item", ItemMatcher.matchItemWithTitleAndDateIssued(this.item, "Public item 1", "2017-10-17")));
    }

    @Test
    public void linksToFirstItemWhenMultipleItems() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("testname").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Public item 2").withIssueDate("2020-07-08").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("SecondEntry").build();
        this.itemService.addBundle(this.context, item2, this.bundle1);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + this.bundle1.getID() + "/item"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", ItemMatcher.matchItemWithTitleAndDateIssued(this.item, "Public item 1", "2017-10-17")));
    }
}

