/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.matcher.HarvesterMetadataMatcher;
import org.dspace.app.rest.matcher.MetadataConfigsMatcher;
import org.dspace.app.rest.model.HarvestTypeEnum;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CollectionHarvestSettingsControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    HarvestedCollectionService harvestedCollectionService;
    Collection collection;
    Collection collectionNoHarvestSettings;
    EPerson ePersonWithWriteRights;

    @Before
    public void SetUp() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community community = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 1").build();
        this.collectionNoHarvestSettings = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection 2").build();
        this.ePersonWithWriteRights = EPersonBuilder.createEPerson((Context)this.context).withEmail("email@email.com").withPassword(this.password).build();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collection, 1, this.ePersonWithWriteRights);
        this.context.restoreAuthSystemState();
    }

    public JSONObject createHarvestSettingsJson(String harvestType, String oaiSource, String oaiSetId, String metadataConfigId) {
        JSONObject json = new JSONObject();
        json.put("harvest_type", (Object)harvestType);
        json.put("oai_source", (Object)oaiSource);
        json.put("oai_set_id", (Object)oaiSetId);
        json.put("metadata_config_id", (Object)metadataConfigId);
        return json;
    }

    @Test
    public void GetCollectionHarvestSettings() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        List configs = OAIHarvester.getAvailableMetadataFormats();
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://dspace.org/oai/request", "col_1721.1_114174", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HarvesterMetadataMatcher.matchFullEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HarvesterMetadataMatcher.matchLinks())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_type", (Matcher)Matchers.is((Object)"METADATA_ONLY"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.oai_source", (Matcher)Matchers.is((Object)"https://dspace.org/oai/request"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.oai_set_id", (Matcher)Matchers.is((Object)"col_1721.1_114174"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_message", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata_config_id", (Matcher)Matchers.is((Object)"dc"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_status", (Matcher)Matchers.is((Object)"READY"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_start_time", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.last_harvested", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("api/core/collections/" + this.collection.getID() + "/harvester")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.harvestermetadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataConfigsMatcher.matchMetadataConfigs(configs)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.harvestermetadata._links.self.href", (Matcher)Matchers.endsWith((String)"/api/config/harvestermetadata")));
    }

    @Test
    public void GetCollectionHarvestSettingsIfNotAdmin() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void GetAndPutCollectionHarvestSettingsIfUserHasWriteRights() throws Exception {
        this.context.setCurrentUser(this.ePersonWithWriteRights);
        String token = this.getAuthToken(this.ePersonWithWriteRights.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://dspace.org/oai/request", "col_1721.1_114174", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void getAndPutCollectionHarvestSettingsAnonymousUserException() throws Exception {
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://dspace.org/oai/request", "col_1721.1_114174", "dc");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void GetAndPutCollectionHarvestSettingsIfUserHasNoWriteRightsException() throws Exception {
        this.context.setCurrentUser(this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://dspace.org/oai/request", "col_1721.1_114174", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCollectionHarvestSettingsIfNotSet() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        List configs = OAIHarvester.getAvailableMetadataFormats();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + this.collectionNoHarvestSettings.getID() + "/harvester"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_type", (Matcher)Matchers.is((Object)"NONE"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.oai_source", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.oai_set_id", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_message", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata_config_id", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_status", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.harvest_start_time", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.last_harvested", (Matcher)Matchers.is((Matcher)Matchers.nullValue()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.endsWith((String)("api/core/collections/" + this.collectionNoHarvestSettings.getID() + "/harvester")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.harvestermetadata", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{MetadataConfigsMatcher.matchMetadataConfigs(configs)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.harvestermetadata._links.self.href", (Matcher)Matchers.endsWith((String)"/api/config/harvestermetadata")));
    }

    @Test
    public void PutWorksWithStandardSettings() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://dspace.org/oai/request", "col_1721.1_114174", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isOk());
        HarvestedCollection harvestedCollection = this.harvestedCollectionService.find(this.context, this.collection);
        Assert.assertTrue((harvestedCollection.getHarvestType() == HarvestTypeEnum.valueOf((String)json.getString("harvest_type")).getValue() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)harvestedCollection.getOaiSource().equals(json.getString("oai_source")));
        Assert.assertTrue((boolean)harvestedCollection.getOaiSetId().equals(json.getString("oai_set_id")));
        Assert.assertTrue((boolean)harvestedCollection.getHarvestMetadataConfig().equals(json.getString("metadata_config_id")));
    }

    @Test
    public void PutUnProcessableEntityIfIncorrectSettings() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("METADATA_ONLY", "https://mydspace.edu/oai/request", "col_1721.1_114174", "bc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void PutHarvestSettingsDeletedIfHarvestTypeIsNone() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("NONE", "", "", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isOk());
        HarvestedCollection harvestedCollection = this.harvestedCollectionService.find(this.context, this.collection);
        Assert.assertNull((Object)harvestedCollection);
    }

    @Test
    public void PutUnauthorizedIfNotAuthenticated() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void PutForbiddenIfNotEnoughpermissions() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void PutNotFoundIfNoSuchCollection() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        String fakeUuid = "6c9a081e-f2e5-42cd-8cf8-338f64b0841b";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + fakeUuid + "/harvester"), (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void PutUnprocessableEntityIfHarvestTypeIncorrect() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        JSONObject json = this.createHarvestSettingsJson("INCORRECT_HARVEST_TYPE", "https://mydspace.edu/oai/request", "col_1721.1_114174", "dc");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + this.collection.getID() + "/harvester"), (Object[])new Object[0]).contentType("application/json").content(json.toString())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

