/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.PageMatcher;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CollectionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    CollectionConverter collectionConverter;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    ResourcePolicyService resoucePolicyService;
    @Autowired
    GroupService groupService;

    @Test
    public void findAllTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())})));
    }

    @Test
    public void findAllUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollection(col1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col1), CollectionMatcher.matchCollection(col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String tokenCol1Admin = this.getAuthToken(col1Admin.getEmail(), "qwerty02");
        this.getClient(tokenCol1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(col1), CollectionMatcher.matchCollection(col2)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("size", new String[]{"1"}).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"}).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))));
    }

    @Test
    public void findOneCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchSpecificEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())));
    }

    @Test
    public void findOneCollectionFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntryFullProjection(col1.getName(), col1.getID(), col1.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not(CollectionMatcher.matchCollectionEntryFullProjection(col1.getName(), col1.getID(), col1.getHandle()))));
    }

    @Test
    public void findOneCollectionUnAuthenticatedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneCollectionForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneCollectionGrantAccessAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson parentAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson1@mail.com").withPassword("qwerty01").build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{parentAdmin}).build();
        EPerson col1Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword("qwerty02").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withAdminGroup(new EPerson[]{col1Admin}).build();
        EPerson col2Admin = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson3@mail.com").withPassword("qwerty03").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withAdminGroup(new EPerson[]{col2Admin}).build();
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)this.parentCommunity, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col1, 0);
        this.resoucePolicyService.removePolicies(this.context, (DSpaceObject)col2, 0);
        this.context.restoreAuthSystemState();
        String tokenParentAdmin = this.getAuthToken(parentAdmin.getEmail(), "qwerty01");
        this.getClient(tokenParentAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollection(col1))));
        String tokenCol1Admin = this.getAuthToken(col1Admin.getEmail(), "qwerty02");
        this.getClient(tokenCol1Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollection(col1))));
        String tokenCol2Admin = this.getAuthToken(col2Admin.getEmail(), "qwerty03");
        this.getClient(tokenCol2Admin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneCollectionRelsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/logo"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.format.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.format.href", (Matcher)Matchers.containsString((String)"/format"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.content.href", (Matcher)Matchers.containsString((String)"/api/core/bitstreams"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.content.href", (Matcher)Matchers.containsString((String)"/content")));
    }

    @Test
    public void findAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAuthorizedCollectionsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 3").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Group ChildGroupOfSubmitterGroup = GroupBuilder.createGroup((Context)this.context).withName("Child group of submitters").withParent(col1.getSubmitters()).addMember(eperson2).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        String tokenEPerson2 = this.getAuthToken(eperson2.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAuthorizedCollectionsWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson eperson2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("eperson2@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Test collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection of sample items").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Testing autocomplete in submission").withSubmitterGroup(new EPerson[]{eperson2}).build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"collection"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"COLLECTION"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String tokenEPerson2 = this.getAuthToken(eperson2.getEmail(), this.password);
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenEPerson2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"testing auto"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"items sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorized", (Object[])new Object[0]).param("query", new String[]{"test"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col4.getName(), col4.getID(), col4.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findAuthorizedByCommunityWithQueryTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Sample collection").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Test collection").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection of sample items").build();
        Collection col4 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Testing autocomplete in submission").build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCom = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()}).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{child2.getID().toString()}).param("query", new String[]{"sample"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAuthorizedByCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAuthorizedByCommunityAdminsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson adminParentCom = EPersonBuilder.createEPerson((Context)this.context).withEmail("adminParentCom@mail.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{adminParentCom}).build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 3").build();
        this.context.restoreAuthSystemState();
        String tokenAdminParentCom = this.getAuthToken(adminParentCom.getEmail(), this.password);
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdminParentCom).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{child1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{this.parentCommunity.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchProperties(col2.getName(), col2.getID(), col2.getHandle()), CollectionMatcher.matchProperties(col3.getName(), col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findAuthorizedByCommunityWithoutUUIDTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findAuthorizedByCommunityWithUnexistentUUIDTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections/search/findSubmitAuthorizedByCommunity", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneCollectionTestWrongUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findCollectionWithParentCommunity() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.not((Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())))));
    }

    @Test
    public void updateTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)col1, Projection.DEFAULT);
        collectionRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(mapper.writeValueAsBytes((Object)collectionRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection("Electronic theses and dissertations", col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
    }

    @Test
    public void deleteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteTestUnAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefNoEmbeds = new AtomicReference();
        try {
            ObjectMapper mapper = new ObjectMapper();
            CollectionRest collectionRest = new CollectionRest();
            collectionRest.setName("Collection");
            collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
            String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchSpecificEmbeds())).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchNoEmbeds())).andDo(result -> idRefNoEmbeds.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CollectionBuilder.deleteCollection((UUID)((UUID)idRef.get()));
            CollectionBuilder.deleteCollection((UUID)((UUID)idRefNoEmbeds.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTestByAuthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 3, this.eperson);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        try {
            String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)"Title Text")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.handle", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"collection")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "<p>Some cool HTML code here</p>"), MetadataMatcher.matchMetadata("dc.description.abstract", "Sample top-level community created via the REST API"), MetadataMatcher.matchMetadata("dc.description.tableofcontents", "<p>HTML News</p>"), MetadataMatcher.matchMetadata("dc.rights", "Custom Copyright Text"), MetadataMatcher.matchMetadata("dc.title", "Title Text")))))).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        }
        finally {
            CollectionBuilder.deleteCollection((UUID)((UUID)idRef.get()));
        }
    }

    @Test
    public void createTestByUnauthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("Sample top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        this.context.setCurrentUser(this.eperson);
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{this.parentCommunity.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteCollectionEpersonWithDeleteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        Community parentCommunity2 = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community 2").withLogo("SomeTest").build();
        Community parentCommunityChild1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)parentCommunityChild1).withName("Collection 1").build();
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 2, this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 1, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 2);
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 1);
    }

    @Test
    public void updateCollectionEpersonWithWriteRightsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.context.setCurrentUser(this.eperson);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)col1, 1, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)col1, Projection.DEFAULT);
        collectionRest.setMetadata(new MetadataRest().put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Electronic theses and dissertations")}));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(mapper.writeValueAsBytes((Object)collectionRest))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID().toString()), (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntrySpecificEmbedProjection("Electronic theses and dissertations", col1.getID(), col1.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/collections")));
        this.authorizeService.removePoliciesActionFilter(this.context, (DSpaceObject)this.eperson, 1);
    }

    public void patchCollectionMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchCollectionMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/collections/" + col.getID(), expectedStatus);
    }

    @Test
    public void createTestInvalidParentCommunityUUIDBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).param("parent", new String[]{"123"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createTestWithoutParentCommunityUUIDBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withLogo("ThisIsSomeDummyText").build();
        ObjectMapper mapper = new ObjectMapper();
        CollectionRest collectionRest = new CollectionRest();
        collectionRest.setName("Collection");
        collectionRest.setMetadata(new MetadataRest().put("dc.description", new MetadataValueRest[]{new MetadataValueRest("<p>Some cool HTML code here</p>")}).put("dc.description.abstract", new MetadataValueRest[]{new MetadataValueRest("top-level community created via the REST API")}).put("dc.description.tableofcontents", new MetadataValueRest[]{new MetadataValueRest("<p>HTML News</p>")}).put("dc.rights", new MetadataValueRest[]{new MetadataValueRest("Custom Copyright Text")}).put("dc.title", new MetadataValueRest[]{new MetadataValueRest("Title Text")}));
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/collections", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)collectionRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findAllCollectionsWithMultilanguageTitlesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withNameForLanguage("Collection 1", "en").withNameForLanguage("Col 1", "fr").withNameForLanguage("Coll 1", "de").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page", PageMatcher.pageEntryWithTotalPagesAndElements(0, 20, 1, 2)));
    }

    @Test
    public void projectonLevelTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1child).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(child1.getName(), child1.getID(), child1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo._embedded.format", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchCollectionEntry(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems._embedded.mappedItems", (Object[])new Object[0]).isEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(child1.getName(), child1.getID(), child1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities", (Matcher)Matchers.contains(CommunityMatcher.matchCommunityEntry(child1child.getID(), child1child.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities[0]._embedded.collections._embedded.collections", (Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntry(col2.getName(), col2.getID(), col2.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity._embedded.subcommunities._embedded.subcommunities[0]._embedded.collections._embedded.collections[0]._embedded.logo", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.logo._embedded.format", (Object[])new Object[0]).exists());
    }

    @Test
    public void projectonLevelEmbedLevelDepthHigherThanEmbedMaxBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void projectonLevelEmbedLevelDepthNotPresentBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Community child1child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)child1).withName("Sub Community Two").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withLogo("TestingContentForLogo").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"level"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testHiddenMetadataForAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dc.description.provenance")));
    }

    @Test
    public void testHiddenMetadataForAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.description.provenance", "Provenance Data")));
    }

    @Test
    public void testHiddenMetadataForUserWithWriteRights() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Data").withNameForLanguage("Col 1", "en").build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withUser(this.eperson).withAction(1).withDspaceObject((DSpaceObject)col1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CollectionMatcher.matchProperties(col1.getName(), col1.getID(), col1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dc.title", "Collection 1"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void findAllWithHiddenMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withProvenance("Provenance Test 1").withNameForLanguage("col1", "en").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withProvenance("Provenance Test 2").withNameForLanguage("col2", "it").build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/collections", (Object[])new Object[0]).param("embed", new String[]{CollectionMatcher.getEmbedsParameter()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col1.getName(), col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntrySpecificEmbedProjection(col2.getName(), col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata.['dc.description.provenance']", (Object[])new Object[0]).doesNotExist());
    }
}

