/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EntityTypeRestRepositoryIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private EntityTypeService entityTypeService;

    @Test
    public void getAllEntityTypeEndpoint() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Person")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "OrgUnit")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalVolume")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue"))})));
    }

    @Test
    public void getAllEntityTypeEndpointWithPaging() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Person")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "OrgUnit")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal"))})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("size", new String[]{"5"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)7))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalVolume")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue"))})));
    }

    @Test
    public void retrieveOneEntityType() throws Exception {
        EntityType entityType = this.entityTypeService.findByEntityType(this.context, "Publication");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/" + entityType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EntityTypeMatcher.matchEntityTypeEntry(entityType)));
    }

    @Test
    public void retrieveOneEntityTypeThatDoesNotExist() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/5555", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

