/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CommunityBuilder;
import org.dspace.core.Context;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class IdentifierRestControllerIT
extends AbstractControllerIntegrationTest {
    @Before
    public void setup() throws Exception {
        super.setUp();
    }

    @Test
    public void testValidIdentifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
        String handle = this.parentCommunity.getHandle();
        String communityDetail = "http://localhost/api/core/communities/" + this.parentCommunity.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find?id={handle}", (Object[])new Object[]{handle})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", communityDetail));
    }

    @Test
    public void testUnexistentIdentifier() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find?id={id}", (Object[])new Object[]{"fakeIdentifier"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @Ignore
    public void testMissingIdentifierParameter() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

