/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.dspace.app.rest.matcher.RelationshipTypeMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.content.EntityType;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class InitializeEntitiesIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private ConfigurationService configurationService;

    @Before
    public void setup() throws Exception {
        String pathToFile = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "entities" + File.separator + "relationship-types.xml";
        this.runDSpaceScript(new String[]{"initialize-entities", "-f", pathToFile});
    }

    @After
    public void destroy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List relationshipTypeList = this.relationshipTypeService.findAll(this.context);
        List entityTypeList = this.entityTypeService.findAll(this.context);
        List relationships = this.relationshipService.findAll(this.context);
        Iterator relationshipIterator = relationships.iterator();
        while (relationshipIterator.hasNext()) {
            Relationship relationship = (Relationship)relationshipIterator.next();
            relationshipIterator.remove();
            this.relationshipService.delete(this.context, (Object)relationship);
        }
        Iterator relationshipTypeIterator = relationshipTypeList.iterator();
        while (relationshipTypeIterator.hasNext()) {
            RelationshipType relationshipType = (RelationshipType)relationshipTypeIterator.next();
            relationshipTypeIterator.remove();
            this.relationshipTypeService.delete(this.context, (Object)relationshipType);
        }
        Iterator entityTypeIterator = entityTypeList.iterator();
        while (entityTypeIterator.hasNext()) {
            EntityType entityType = (EntityType)entityTypeIterator.next();
            entityTypeIterator.remove();
            this.entityTypeService.delete(this.context, (Object)entityType);
        }
        super.destroy();
    }

    @Test
    public void getAllRelationshipTypesTest() throws Exception {
        List relationshipTypes = this.relationshipTypeService.findAll(this.context);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationshiptypes", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)CoreMatchers.containsString((String)"api/core/relationshiptypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationshiptypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(0)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(1)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(2)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(3)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(4)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(5)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(6)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(7)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(8)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(9))})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + ((RelationshipType)relationshipTypes.get(0)).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMinCardinality", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void updateRelationshipTypesTest() throws Exception {
        List relationshipTypes = this.relationshipTypeService.findAll(this.context);
        String pathToFile = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "entities" + File.separator + "relationship-types-update.xml";
        this.runDSpaceScript(new String[]{"initialize-entities", "-f", pathToFile});
        RelationshipType alteredRelationshipType = (RelationshipType)relationshipTypes.get(0);
        alteredRelationshipType.setLeftMinCardinality(Integer.valueOf(10));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationshiptypes", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)10))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)CoreMatchers.containsString((String)"api/core/relationshiptypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationshiptypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipTypeMatcher.matchRelationshipTypeEntry(alteredRelationshipType), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(1)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(2)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(3)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(4)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(5)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(6)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(7)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(8)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(9))})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + ((RelationshipType)relationshipTypes.get(0)).getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMinCardinality", (Matcher)Matchers.is((Object)10)));
    }
}

