/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Locale;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.authority.ChoiceAuthorityServiceImpl;
import org.dspace.core.Context;
import org.dspace.core.LegacyPluginServiceImpl;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LanguageSupportIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private LegacyPluginServiceImpl legacyPluginService;
    @Autowired
    private ChoiceAuthorityServiceImpl choiceAuthorityServiceImpl;

    @Test
    public void checkDefaultLanguageAnonymousTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.header().stringValues("Content-Language", new String[]{"en"}));
    }

    @Test
    @Ignore(value="This test fails due to a bug in the MockHttpResponseServlet, see https://github.com/spring-projects/spring-framework/issues/25281")
    public void checkEnabledMultipleLanguageSupportTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String[] supportedLanguage = new String[]{"uk", "it"};
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.legacyPluginService.clearNamedPluginClasses();
        this.choiceAuthorityServiceImpl.clearCache();
        Locale it = new Locale("it");
        EPerson epersonUK = EPersonBuilder.createEPerson((Context)this.context).withEmail("epersonUK@example.com").withPassword(this.password).withLanguage("uk").build();
        EPerson epersonFR = EPersonBuilder.createEPerson((Context)this.context).withEmail("epersonFR@example.com").withPassword(this.password).withLanguage("fr").build();
        this.context.restoreAuthSystemState();
        String tokenEPersonUK = this.getAuthToken(epersonUK.getEmail(), this.password);
        String tokenEPersonFR = this.getAuthToken(epersonFR.getEmail(), this.password);
        this.getClient(tokenEPersonUK).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.header().stringValues("Content-Language", new String[]{"uk, it"}));
        this.getClient(tokenEPersonUK).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0]).locale(it)).andExpect(MockMvcResultMatchers.header().stringValues("Content-Language", new String[]{"uk, it"}));
        this.getClient(tokenEPersonFR).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0]).locale(it)).andExpect(MockMvcResultMatchers.header().stringValues("Content-Language", new String[]{"uk, it"}));
        this.configurationService.setProperty("webui.supported.locales", null);
        this.legacyPluginService.clearNamedPluginClasses();
        this.choiceAuthorityServiceImpl.clearCache();
    }
}

