/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.matcher.ItemMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class MappedCollectionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void itemHasNoExtraCollectionsAndCollectionHasNoExtraItemsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 3", col2.getID(), col2.getHandle())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))));
    }

    @Test
    public void itemAndCollectionHaveOneMappingTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\n"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 2", col2.getID(), col2.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)1)));
    }

    @Test
    public void itemAndTwoCollectionsHaveTwoMappingsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col3.getID() + "\n"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 2", col2.getID(), col2.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 3", col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)1)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col3.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)1)));
    }

    @Test
    public void itemHasNoDuplicatesInMappedCollectionAndCollectionHasNoDuplicatesInMappedItemsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col3.getID()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 2", col2.getID(), col2.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 3", col3.getID(), col3.getHandle())}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ItemMatcher.matchItemProperties(publicItem1), ItemMatcher.matchItemProperties(publicItem1)}))));
    }

    @Test
    public void itemHasNoOriginalCollectionInMappedCollectionAndCollectionHasNoOriginalItemInMappedItemsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col3.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col3.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col1.getID() + "\n"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
    }

    @Test
    public void removeMappedCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 3").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col2.getID() + "\nhttps://localhost:8080/spring-rest/api/core/collections/" + col3.getID() + "\n"));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.contains(CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle()))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/" + col2.getID()), (Object[])new Object[0]));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 2", col2.getID(), col2.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col3.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/" + col1.getID()), (Object[])new Object[0]));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 2", col2.getID(), col2.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col2.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.not((Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col3.getID() + "/mappedItems"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.contains(ItemMatcher.matchItemProperties(publicItem1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedItems", (Matcher)Matchers.hasSize((int)1)));
    }

    @Test
    public void doNotAllowMappedCollectionIfGivenCollectionIsOwningCollectionOfGivenItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col1.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void doNotAllowDeleteMappedCollectionIfGivenCollectionIsOwningCollectionOfGivenItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void doNotAllowMappedCollectionWithATemplateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withTemplateItem().build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item templateItem = col1.getTemplateItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + templateItem.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void doNotAllowDeleteMappedCollectionWithATemplateItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withTemplateItem().build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item templateItem = col1.getTemplateItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + templateItem.getID() + "/mappedCollections/" + col2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void mappedCollectionNeedsValidIDs() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/badCollectionID")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/items/badItemID/mappedCollections/", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col1.getID())).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void itemHasNoExtraCollectionsCanBeRetrievedAnonymouslyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.context.restoreAuthSystemState();
        this.context.setCurrentUser(null);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.mappedCollections", (Matcher)Matchers.not((Matcher)Matchers.contains((Matcher[])new Matcher[]{CollectionMatcher.matchCollectionEntry("Collection 1", col1.getID(), col1.getHandle()), CollectionMatcher.matchCollectionEntry("Collection 3", col2.getID(), col2.getHandle())})))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/items")));
    }

    @Test
    public void mappingNewCollectionCannotBeDoneAnonymouslyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().is(401));
    }

    @Test
    public void removingMappedCollectionCannotBeDoneAnonymouslyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID()));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + publicItem1.getID() + "/mappedCollections/" + col2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(401));
    }
}

