/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.app.rest.matcher.RelationshipTypeMatcher;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.h2.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RelationshipTypeRestRepositoryIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;

    @Test
    public void findAllRelationshipTypesTest() throws SQLException {
        Assert.assertEquals((long)11L, (long)this.relationshipTypeService.findAll(this.context).size());
    }

    @Test
    public void findPublicationPersonRelationshipType() throws SQLException {
        String leftTypeString = "Publication";
        String rightTypeString = "Person";
        String leftwardType = "isAuthorOfPublication";
        String rightwardType = "isPublicationOfAuthor";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findPublicationProjectRelationshipType() throws SQLException {
        String leftTypeString = "Publication";
        String rightTypeString = "Project";
        String leftwardType = "isProjectOfPublication";
        String rightwardType = "isPublicationOfProject";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findPublicationOrgUnitRelationshipType() throws SQLException {
        String leftTypeString = "Publication";
        String rightTypeString = "OrgUnit";
        String leftwardType = "isOrgUnitOfPublication";
        String rightwardType = "isPublicationOfOrgUnit";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findPersonProjectRelationshipType() throws SQLException {
        String leftTypeString = "Person";
        String rightTypeString = "Project";
        String leftwardType = "isProjectOfPerson";
        String rightwardType = "isPersonOfProject";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findPersonOrgUnitRelationshipType() throws SQLException {
        String leftTypeString = "Person";
        String rightTypeString = "OrgUnit";
        String leftwardType = "isOrgUnitOfPerson";
        String rightwardType = "isPersonOfOrgUnit";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findProjectOrgUnitRelationshipType() throws SQLException {
        String leftTypeString = "Project";
        String rightTypeString = "OrgUnit";
        String leftwardType = "isOrgUnitOfProject";
        String rightwardType = "isProjectOfOrgUnit";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findJournalJournalVolumeRelationshipType() throws SQLException {
        String leftTypeString = "Journal";
        String rightTypeString = "JournalVolume";
        String leftwardType = "isVolumeOfJournal";
        String rightwardType = "isJournalOfVolume";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    @Test
    public void findJournalVolumeJournalIssueRelationshipType() throws SQLException {
        String leftTypeString = "JournalVolume";
        String rightTypeString = "JournalIssue";
        String leftwardType = "isIssueOfJournalVolume";
        String rightwardType = "isJournalVolumeOfIssue";
        this.checkRelationshipType(leftTypeString, rightTypeString, leftwardType, rightwardType);
    }

    private void checkRelationshipType(String leftType, String rightType, String leftwardType, String rightwardType) throws SQLException {
        RelationshipType relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, leftType), this.entityTypeService.findByEntityType(this.context, rightType), leftwardType, rightwardType);
        Assert.assertNotNull((Object)relationshipType);
        Assert.assertEquals((Object)this.entityTypeService.findByEntityType(this.context, leftType), (Object)relationshipType.getLeftType());
        Assert.assertEquals((Object)this.entityTypeService.findByEntityType(this.context, rightType), (Object)relationshipType.getRightType());
        Assert.assertEquals((Object)leftwardType, (Object)relationshipType.getLeftwardType());
        Assert.assertEquals((Object)rightwardType, (Object)relationshipType.getRightwardType());
    }

    @Test
    public void getAllRelationshipTypesEndpointTest() throws Exception {
        List relationshipTypes = this.relationshipTypeService.findAll(this.context);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/relationshiptypes", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)11))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)CoreMatchers.containsString((String)"api/core/relationshiptypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationshiptypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(0)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(1)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(2)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(3)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(4)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(5)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(6)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(7)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(8)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(9)), RelationshipTypeMatcher.matchRelationshipTypeEntry((RelationshipType)relationshipTypes.get(10))})));
    }

    @Test
    public void entityTypeForPublicationPersonRelationshipTypeTest() throws Exception {
        List relationshipTypes = this.relationshipTypeService.findAll(this.context);
        RelationshipType foundRelationshipType = null;
        for (RelationshipType relationshipType : relationshipTypes) {
            if (!StringUtils.equals((String)relationshipType.getLeftwardType(), (String)"isAuthorOfPublication") || !StringUtils.equals((String)relationshipType.getRightwardType(), (String)"isPublicationOfAuthor")) continue;
            foundRelationshipType = relationshipType;
            break;
        }
        if (foundRelationshipType == null) {
            throw new Exception("RelationshipType not found for isIssueOfJournalVolume");
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + foundRelationshipType.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.leftType", EntityTypeMatcher.matchEntityTypeEntryForLabel("Publication"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.rightType", EntityTypeMatcher.matchEntityTypeEntryForLabel("Person")));
    }

    @Test
    public void cardinalityOnAuthorPublicationRelationshipTypesTest() throws Exception {
        RelationshipType relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        Assert.assertEquals((Object)0, (Object)relationshipType.getLeftMinCardinality());
        Assert.assertEquals((Object)0, (Object)relationshipType.getRightMinCardinality());
        Assert.assertNull((Object)relationshipType.getLeftMaxCardinality());
        Assert.assertNull(null, (Object)relationshipType.getRightMaxCardinality());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + relationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMinCardinality", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightMinCardinality", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMaxCardinality", (Matcher)Matchers.isEmptyOrNullString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightMaxCardinality", (Matcher)Matchers.isEmptyOrNullString()));
    }

    @Test
    public void entityTypeForIssueJournalRelationshipTypeTest() throws Exception {
        List relationshipTypes = this.relationshipTypeService.findAll(this.context);
        RelationshipType foundRelationshipType = null;
        for (RelationshipType relationshipType : relationshipTypes) {
            if (!StringUtils.equals((String)relationshipType.getLeftwardType(), (String)"isIssueOfJournalVolume") || !StringUtils.equals((String)relationshipType.getRightwardType(), (String)"isJournalVolumeOfIssue")) continue;
            foundRelationshipType = relationshipType;
            break;
        }
        if (foundRelationshipType == null) {
            throw new Exception("RelationshipType not found for isIssueOfJournalVolume");
        }
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + foundRelationshipType.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.leftType", EntityTypeMatcher.matchEntityTypeEntryForLabel("JournalVolume"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.rightType", EntityTypeMatcher.matchEntityTypeEntryForLabel("JournalIssue")));
    }

    @Test
    public void cardinalityOnIssueJournalJournalVolumeRelationshipTypesTest() throws Exception {
        RelationshipType relationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "JournalVolume"), this.entityTypeService.findByEntityType(this.context, "JournalIssue"), "isIssueOfJournalVolume", "isJournalVolumeOfIssue");
        Assert.assertEquals((Object)0, (Object)relationshipType.getLeftMinCardinality());
        Assert.assertEquals((Object)1, (Object)relationshipType.getRightMinCardinality());
        Assert.assertNull((Object)relationshipType.getLeftMaxCardinality());
        Assert.assertEquals((Object)1, (Object)relationshipType.getRightMaxCardinality());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationshiptypes/" + relationshipType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMinCardinality", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightMinCardinality", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftMaxCardinality", (Matcher)Matchers.isEmptyOrNullString())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightMaxCardinality", (Matcher)Matchers.is((Object)1)));
    }
}

