/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ShibbolethRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;

    @Before
    public void setup() throws Exception {
        super.setUp();
        this.configurationService.setProperty("rest.cors.allowed-origins", (Object)"${dspace.ui.url}, http://anotherdspacehost:4000");
    }

    @Test
    public void testRedirectToDefaultDspaceUrl() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000"));
    }

    @Test
    public void testRedirectToGivenTrustedUrl() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://localhost:8080/server/api/authn/status"})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:8080/server/api/authn/status"));
    }

    @Test
    public void testRedirectToAnotherGivenTrustedUrl() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://anotherdspacehost:4000/home"})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://anotherdspacehost:4000/home"));
    }

    @Test
    public void testRedirectToGivenUntrustedUrl() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://dspace.org"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testRedirectRequiresAuth() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

