/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.UUID;
import org.dspace.app.rest.matcher.SiteMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.builder.SiteBuilder;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SiteRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/sites", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.sites[0]", SiteMatcher.matchEntry(site))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/sites"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + site.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SiteMatcher.matchEntry(site))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/sites")));
    }

    @Test
    public void findOneWrongUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchSiteMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchSiteMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/sites/" + site.getID(), expectedStatus);
    }
}

