/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubmissionCCLicenseUrlRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void searchRightsByQuestionsTest() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license2&answer_license2-field0=license2-field0-enum1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.url", (Matcher)Matchers.is((Object)"mock-license-uri"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissioncclicenseUrl"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license2&answer_license2-field0=license2-field0-enum1")));
    }

    @Test
    public void searchRightsByQuestionsTestLicenseForLicenseWithoutQuestions() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license3", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.url", (Matcher)Matchers.is((Object)"mock-license-uri"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"submissioncclicenseUrl"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.is((Object)"http://localhost/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license3")));
    }

    @Test
    public void searchRightsByQuestionsNonExistingLicense() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=nonexisting-license&answer_license2-field0=license2-field0-enum1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void searchRightsByQuestionsMissingRequiredAnswer() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license1&answer_license1field0=license1field0enum1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchRightsByQuestionsAdditionalNonExistingAnswer() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license2&answer_license2field0=license2field0enum1&answer_nonexisting=test", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchRightsByQuestionsAdditionalUnAuthorized() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/config/submissioncclicenseUrls/search/rightsByQuestions?license=license2&answer_license2-field0=license2-field0-enum1", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

