/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.ClaimedTaskMatcher;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.PoolTaskMatcher;
import org.dspace.app.rest.matcher.WorkflowActionMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkflowStepMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.PoolTaskBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class TaskRestRepositoriesIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;

    @Test
    public void findOnePoolTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOnePoolUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)this.admin).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOnePoolForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findByUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(authReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-18", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        String authReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(authReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String authAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-18", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByUserForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(authReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(authReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByUserUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deletePoolTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)this.admin).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void claimTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskNotExistingTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/pooltasks/2147483647", (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneClaimedTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOneClaimedTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneClaimedTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void unclaimTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void unclaimTaskAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void unclaimTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void unclaimTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void unclaimTaskNotExistingTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/workflow/claimedtasks/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findClaimedByUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 2").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry2").build();
        ClaimedTask claimedTask3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 3").withIssueDate("2017-10-19").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry3").build();
        XmlWorkflowItem witem1 = claimedTask1.getWorkflowItem();
        XmlWorkflowItem witem2 = claimedTask2.getWorkflowItem();
        XmlWorkflowItem witem3 = claimedTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-18", "ExtraEntry2"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask3, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-19", "ExtraEntry3"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-18", "ExtraEntry2"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask3, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-19", "ExtraEntry3"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findClaimedByUserForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 2").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry2").build();
        ClaimedTask claimedTask3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 3").withIssueDate("2017-10-19").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry3").build();
        XmlWorkflowItem witem1 = claimedTask1.getWorkflowItem();
        XmlWorkflowItem witem2 = claimedTask2.getWorkflowItem();
        XmlWorkflowItem witem3 = claimedTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findClaimedByUserUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void approvalTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void approvalForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void rejectTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String submitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(null, "Workflow Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void rejectForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void undefinedActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_undefinedaction", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void actionOnNotExistingClaimedTaskTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks/2147483647", (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void fullWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        Step step = this.xmlWorkflowFactory.getStepByName("reviewstep");
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        WorkflowActionConfig workflowAction = this.xmlWorkflowFactory.getActionByName("reviewaction");
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action", WorkflowActionMatcher.matchWorkflowActionEntry(workflowAction)))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        step = this.xmlWorkflowFactory.getStepByName("editstep");
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        workflowAction = this.xmlWorkflowFactory.getActionByName("editaction");
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action", WorkflowActionMatcher.matchWorkflowActionEntry(workflowAction)))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        step = this.xmlWorkflowFactory.getStepByName("finaleditstep");
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        workflowAction = this.xmlWorkflowFactory.getActionByName("finaleditaction");
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action", WorkflowActionMatcher.matchWorkflowActionEntry(workflowAction)))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void defaultWorkflowTest_UntilReviewStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject in review step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilReviewStep_NonValidOption_EditMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_edit_metadata", new String[]{"true"}).param("reason", new String[]{"I need to test the submit_edit_metadata"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void defaultWorkflowTest_UntilEditStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the submit_reject in edit step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilEditStep_NonValidOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_non_valid_option", new String[]{"true"}).param("reason", new String[]{"I need to test an unvalid option"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test reject in fina edit step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_EditMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_edit_metadata", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_NonValidOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.claimedtasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_non_valid_option", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void unclaimedTaskTest_Upload_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        poolTask.setStepID("editstep");
        poolTask.setActionID("editaction");
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        bibtex.close();
    }

    @Test
    public void unclaimedTaskTest_Patch_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void uploadTest_ClaimedTask_EditMetadataOptionNotAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("reviewstep");
        claimedTask.setActionID("reviewaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        bibtex.close();
    }

    @Test
    public void patchTest_ClaimedTask_EditMetadataOptionNotAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/pooltasks/" + idRef.get()), (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void claimedTaskTest_Upload_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isCreated());
        bibtex.close();
    }
}

