/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.WorkflowStepMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkflowStepRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private static final String WORKFLOW_ACTIONS_ENDPOINT = "/api/config/workflowsteps";

    @Test
    public void getAllWorkflowSteps_NonImplementedEndpoint() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void getAllWorkflowSteps_NonImplementedEndpoint_NonValidToken() throws Exception {
        String token = "NonValidToken";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getAllWorkflowSteps_NonImplementedEndpoint_NoToken() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowStepByName_NonExistentWorkflowStep() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameNonExistentWorkflowActionName = "TestNameNonExistentWorkflowStep9999";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowsteps/" + nameNonExistentWorkflowActionName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowStepByName_ExistentStep_reviewstep() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameStep = "reviewstep";
        Step existentStep = this.xmlWorkflowFactory.getStepByName(nameStep);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowsteps/" + nameStep), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(WorkflowStepMatcher.matchWorkflowStepEntry(existentStep))));
    }
}

