/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanCreateCommunitiesIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private CommunityConverter communityConverter;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private Utils utils;
    private Community communityA;
    private Community communityB;
    private Collection collectionA;
    private AuthorizationFeature canCreateCommunitiesFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("Community A").build();
        this.communityB = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.communityA).withName("Community B").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityB).withName("Collection A").build();
        this.context.restoreAuthSystemState();
        this.canCreateCommunitiesFeature = this.authorizationFeatureService.find("canCreateCommunities");
    }

    @Test
    public void canCreateCommunitiesOnCommunityAsAdminTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        CommunityRest comRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.communityA, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void canCreateCommunitiesOnSiteAsAdminTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void canCreateCommunitiesOnCollectionAsAdminTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, DefaultProjection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnCommunityAsAnonymousTest() throws Exception {
        CommunityRest comRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.communityA, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnSiteAsAnonymousTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnCollectionAsAnonymousTest() throws Exception {
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, DefaultProjection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnCommunityAsEPersonWithoutRightsTest() throws Exception {
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.communityB, 11, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        CommunityRest comRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.communityA, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnSiteAsEPersonWithoutRightsTest() throws Exception {
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.communityB, 11, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnCollectionAsEPersonWithoutRightsTest() throws Exception {
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.communityB, 11, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        CollectionRest collectionRest = (CollectionRest)this.collectionConverter.convert((DSpaceObject)this.collectionA, DefaultProjection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void canCreateCommunitiesOnCommunityAsEPersonWithRightsTest() throws Exception {
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.communityB, 11, this.eperson);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        CommunityRest comRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.communityB, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("feature", new String[]{this.canCreateCommunitiesFeature.getName()}).param("embed", new String[]{"feature"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

