/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LoginOnBehalfOfFeatureRestIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private CommunityConverter communityConverter;
    @Autowired
    private SiteService siteService;
    @Autowired
    private Utils utils;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    private AuthorizationFeature loginOnBehalfOf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.loginOnBehalfOf = this.authorizationFeatureService.find("loginOnBehalfOf");
    }

    @Test
    public void loginOnBehalfOfTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.configurationService.setProperty("webui.user.assumelogin", (Object)true);
        Authorization loginOnBehalfOfAuthorization = new Authorization(this.admin, this.loginOnBehalfOf, (BaseObjectRest)siteRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{String.valueOf(this.admin.getID())}).param("feature", new String[]{this.loginOnBehalfOf.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasItem((Matcher)AuthorizationMatcher.matchAuthorization(loginOnBehalfOfAuthorization))));
    }

    @Test
    public void loginOnBehalfNonSiteObjectOfTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
        CommunityRest communityRest = (CommunityRest)this.communityConverter.convert((DSpaceObject)this.parentCommunity, Projection.DEFAULT);
        String communityUri = this.utils.linkToSingleResource((RestAddressableModel)communityRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.configurationService.setProperty("webui.user.assumelogin", (Object)true);
        Authorization loginOnBehalfOfAuthorization = new Authorization(this.admin, this.loginOnBehalfOf, (BaseObjectRest)communityRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{communityUri}).param("eperson", new String[]{String.valueOf(this.admin.getID())}).param("feature", new String[]{this.loginOnBehalfOf.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void loginOnBehalfOfNonAdminUserNotFoundTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.configurationService.setProperty("webui.user.assumelogin", (Object)true);
        Authorization loginOnBehalfOfAuthorization = new Authorization(this.eperson, this.loginOnBehalfOf, (BaseObjectRest)siteRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{String.valueOf(this.eperson.getID())}).param("feature", new String[]{this.loginOnBehalfOf.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void loginOnBehalfOfNonAdminUserAssumeLoginPropertyFalseNotFoundTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.configurationService.setProperty("webui.user.assumelogin", (Object)false);
        Authorization loginOnBehalfOfAuthorization = new Authorization(this.eperson, this.loginOnBehalfOf, (BaseObjectRest)siteRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{String.valueOf(this.eperson.getID())}).param("feature", new String[]{this.loginOnBehalfOf.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void loginOnBehalfOfAssumeLoginPropertyFalseNotFoundTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.configurationService.setProperty("webui.user.assumelogin", (Object)false);
        Authorization loginOnBehalfOfAuthorization = new Authorization(this.admin, this.loginOnBehalfOf, (BaseObjectRest)siteRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{String.valueOf(this.admin.getID())}).param("feature", new String[]{this.loginOnBehalfOf.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }
}

