/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.model.MockObject;
import org.dspace.app.rest.model.MockObjectRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.EmbeddedPage;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.model.hateoas.MockObjectResource;
import org.dspace.app.rest.projection.MockProjection;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ConverterServiceIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConverterService converter;
    @Mock
    private Object mockObjectWithNoConverter;
    @Mock
    private RestModel mockObjectRestWithNoResource;
    @Mock
    private Link mockLink;
    @Mock
    private Object mockEmbeddedResource;
    @Autowired
    private RequestService requestService;

    @Before
    public void setup() {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.setAttribute("dspace.context", (Object)new Context());
        MockHttpServletResponse mockHttpServletResponse = new MockHttpServletResponse();
        this.requestService.startRequest((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse);
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        Mockito.when((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).thenReturn((Object)this.eperson);
    }

    @Test
    public void toRestNoConverterFound() {
        try {
            this.converter.toRest(this.mockObjectWithNoConverter, Projection.DEFAULT);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"No converter found"));
        }
    }

    @Test(expected=ClassCastException.class)
    public void toRestWrongReturnType() {
        String restObject = (String)this.converter.toRest((Object)MockObject.create(0L), Projection.DEFAULT);
    }

    @Test
    public void toRestWithDefaultProjection() {
        long id = 0L;
        MockObjectRest restObject = (MockObjectRest)((Object)this.converter.toRest((Object)MockObject.create(id), Projection.DEFAULT));
        Assert.assertThat((Object)((Long)restObject.getId()), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((Object)restObject.getValue(), (Matcher)CoreMatchers.equalTo((Object)("value" + id)));
    }

    @Test
    public void toRestWithMockProjection() {
        long id = 0L;
        MockProjection mockProjection = new MockProjection(this.mockLink, this.mockEmbeddedResource);
        MockObjectRest restObject = (MockObjectRest)((Object)this.converter.toRest((Object)MockObject.create(id), (Projection)mockProjection));
        Assert.assertThat((Object)((Long)restObject.getId()), (Matcher)CoreMatchers.equalTo((Object)((id + 1L) * 3L)));
        Assert.assertThat((Object)restObject.getValue(), (Matcher)CoreMatchers.equalTo((Object)("value" + id + "?!")));
    }

    @Test
    public void toResourceNoConstructorFound() {
        try {
            this.converter.toResource(this.mockObjectRestWithNoResource);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"No constructor found"));
        }
    }

    @Test(expected=ClassCastException.class)
    public void toResourceWrongReturnType() {
        MockHalResource mockHalResource = (MockHalResource)this.converter.toResource((RestModel)MockObjectRest.create(0L));
    }

    @Test
    public void toResourceWithDefaultProjection() throws Exception {
        MockObjectRest r0 = MockObjectRest.create(0L);
        MockObjectRest restPropNotNullValue = MockObjectRest.create(1L);
        MockObjectRest restPropRenamedValue = MockObjectRest.create(2L);
        MockObjectRest restPropUnannotatedValue = MockObjectRest.create(3L);
        r0.setRestPropNotNull(restPropNotNullValue);
        r0.setRestPropRenamed(restPropRenamedValue);
        r0.setRestPropUnannotated(restPropUnannotatedValue);
        String r0json = new ObjectMapper().writeValueAsString((Object)r0);
        MockObjectResource resource = (MockObjectResource)this.converter.toResource((RestModel)r0);
        Assert.assertThat((Object)new ObjectMapper().writeValueAsString((Object)r0), (Matcher)CoreMatchers.equalTo((Object)r0json));
        this.assertHasEmbeds((HALResource)resource, new String[]{"restPropUnannotated"}, new Class[]{EntityModel.class});
        this.assertHasLinks((EntityModel)resource, new String[]{"self", "restPropNotNull", "restPropNull", "restPropRenamedWithSuffix", "restPropUnannotated", "optionallyEmbeddedChildren", "neverEmbeddedChildren"});
    }

    @Test
    public void toResourceWithMockProjection() throws Exception {
        MockObjectRest r0 = MockObjectRest.create(0L);
        MockObjectRest restPropNotNullValue = MockObjectRest.create(1L);
        MockObjectRest restPropRenamedValue = MockObjectRest.create(2L);
        MockObjectRest restPropUnannotatedValue = MockObjectRest.create(3L);
        r0.setRestPropNotNull(restPropNotNullValue);
        r0.setRestPropRenamed(restPropRenamedValue);
        r0.setRestPropUnannotated(restPropUnannotatedValue);
        String r0json = new ObjectMapper().writeValueAsString((Object)r0);
        Mockito.when((Object)this.mockLink.getRel()).thenReturn(() -> "mockLink");
        r0.setProjection(new MockProjection(this.mockLink, this.mockEmbeddedResource));
        MockObjectResource resource = (MockObjectResource)this.converter.toResource((RestModel)r0);
        Assert.assertThat((Object)new ObjectMapper().writeValueAsString((Object)r0), (Matcher)CoreMatchers.equalTo((Object)r0json));
        this.assertHasEmbeds((HALResource)resource, new String[]{"restPropNotNull", "restPropNull", "restPropRenamedWithSuffix", "restPropUnannotated", "optionallyEmbeddedChildren", "resource"}, new Class[]{EntityModel.class, null, EntityModel.class, EntityModel.class, EmbeddedPage.class, Object.class});
        this.assertEmbeddedPageSize((HALResource)resource, "optionallyEmbeddedChildren", 2);
        this.assertHasLinks((EntityModel)resource, new String[]{"self", "restPropUnannotated", "optionallyEmbeddedChildren", "neverEmbeddedChildren", "mockLink"});
    }

    private void assertHasLinks(EntityModel resource, String[] rels) {
        HashMap map = new HashMap();
        resource.getLinks().stream().forEach(link -> map.put(link.getRel().value(), link));
        Assert.assertThat(new TreeSet(map.keySet()), (Matcher)CoreMatchers.equalTo(new TreeSet(Sets.newHashSet((Object[])rels))));
    }

    private void assertHasEmbeds(HALResource resource, String[] rels, Class[] classes) {
        Assert.assertThat(new TreeSet(resource.getEmbeddedResources().keySet()), (Matcher)CoreMatchers.equalTo(new TreeSet(Sets.newHashSet((Object[])rels))));
        for (int i = 0; i < rels.length; ++i) {
            String rel = rels[i];
            Class expectedClass = classes[i];
            Object value = resource.getEmbeddedResources().get(rel);
            if (expectedClass == null) {
                if (value == null) continue;
                Assert.fail((String)("expected null value for embed: " + rel));
                continue;
            }
            if (value == null) {
                Assert.fail((String)("got null value, but expected a " + expectedClass + " for embed: " + rel));
                continue;
            }
            Assert.assertTrue((String)("got a " + value.getClass() + " value, but expected a " + expectedClass + " for embed: " + rel), (boolean)expectedClass.isAssignableFrom(value.getClass()));
        }
    }

    private void assertEmbeddedPageSize(HALResource resource, String rel, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)((List)((EmbeddedPage)resource.getEmbeddedResources().get(rel)).getPageContent().get(rel)).size());
    }

    class MockHalResource
    extends HALResource<MockRestAddressableModel> {
        public MockHalResource(MockRestAddressableModel content) {
            super((Object)content);
        }
    }

    class MockRestAddressableModel
    extends RestAddressableModel {
        MockRestAddressableModel() {
        }

        public String getCategory() {
            return null;
        }

        public Class getController() {
            return null;
        }

        public String getType() {
            return null;
        }
    }
}

