/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.RootConverter;
import org.dspace.app.rest.model.RootRest;
import org.dspace.services.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RootConverterTest {
    @InjectMocks
    private RootConverter rootConverter;
    @Mock
    private ConfigurationService configurationService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.configurationService.getProperty("dspace.ui.url")).thenReturn((Object)"dspaceurl");
        Mockito.when((Object)this.configurationService.getProperty("dspace.name")).thenReturn((Object)"dspacename");
        Mockito.when((Object)this.configurationService.getProperty("dspace.server.url")).thenReturn((Object)"rest");
    }

    @Test
    public void testReturnCorrectClass() throws Exception {
        Assert.assertEquals(this.rootConverter.convert().getClass(), RootRest.class);
    }

    @Test
    public void testCorrectPropertiesSetFromConfigurationService() throws Exception {
        String restUrl = "rest";
        RootRest rootRest = this.rootConverter.convert();
        Assert.assertEquals((Object)"dspaceurl", (Object)rootRest.getDspaceUI());
        Assert.assertEquals((Object)"dspacename", (Object)rootRest.getDspaceName());
        Assert.assertEquals((Object)restUrl, (Object)rootRest.getDspaceServer());
    }

    @Test
    public void testReturnNotNull() throws Exception {
        Assert.assertNotNull((Object)this.rootConverter.convert());
    }
}

