/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter.query;

import java.util.LinkedList;
import java.util.List;
import org.dspace.app.rest.converter.query.SearchQueryConverter;
import org.dspace.app.rest.parameter.SearchFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SearchQueryConverterTest {
    SearchQueryConverter searchQueryConverter;

    @Before
    public void setUp() throws Exception {
        this.searchQueryConverter = new SearchQueryConverter();
    }

    @Test
    public void convertAuthorContainsSearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "test*");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"contains");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"test*");
    }

    @Test
    public void convertAuthorNotContainsSearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "-test*");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"notcontains");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"-test*");
    }

    @Test
    public void convertAuthorEqualsSearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "test");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"equals");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"test");
    }

    @Test
    public void convertAuthorNotEqualsSearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "-test");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"notequals");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"-test");
    }

    @Test
    public void convertAuthorAuthoritySearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "id:test");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"authority");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"id:test");
    }

    @Test
    public void convertAuthorNotAuthoritySearchFilterTest() {
        SearchFilter searchFilter = new SearchFilter("author", "query", "-id:test");
        LinkedList<SearchFilter> list = new LinkedList<SearchFilter>();
        list.add(searchFilter);
        List transformedList = this.searchQueryConverter.convert(list);
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getOperator(), (Object)"notauthority");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getOperator(), (Object)"query");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getName(), (Object)"author");
        Assert.assertEquals((Object)((SearchFilter)transformedList.get(0)).getValue(), (Object)"test");
        Assert.assertEquals((Object)((SearchFilter)list.get(0)).getValue(), (Object)"-id:test");
    }
}

