/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.csv;

import com.google.gson.Gson;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.matcher.ProcessMatcher;
import org.dspace.app.rest.matcher.RelationshipMatcher;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ProcessStatus;
import org.dspace.content.Relationship;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CsvImportIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;

    @Test
    public void createRelationshipsWithCsvImportTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("OrgUnits").build();
        Item article = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Article").withIssueDate("2017-10-17").withRelationshipType("Publication").build();
        Item itemB = this.validateSpecificItemRelationCreationCsvImport(col1, article, "TestItemB", "Person", "isPublicationOfAuthor", "Relationship list size is 1", 1, 0, 0);
        Item itemC = this.validateSpecificItemRelationCreationCsvImport(col1, article, "TestItemC", "Person", "isPublicationOfAuthor", "Relationship list size is 1", 1, 1, 0);
        Item itemD = this.validateSpecificItemRelationCreationCsvImport(col1, article, "TestItemD", "Project", "isPublicationOfProject", "Relationship list size is 1", 1, 0, 0);
        Item itemE = this.validateSpecificItemRelationCreationCsvImportMultiple(col1, "TestItemE", "Publication", "isAuthorOfPublication", "Relationship list size is 2", 2, 0, 1, itemC, itemB);
        List relationships = this.relationshipService.findByItem(this.context, itemE);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + ((Relationship)relationships.get(0)).getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)itemC.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RelationshipMatcher.matchRelationship((Relationship)relationships.get(0)))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + ((Relationship)relationships.get(1)).getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.rightItem.href", (Matcher)Matchers.containsString((String)itemB.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RelationshipMatcher.matchRelationship((Relationship)relationships.get(1)))));
        Item itemF = this.validateSpecificItemRelationCreationCsvImport(col1, itemE, "TestItemF", "Person", "isPublicationOfAuthor", "Relationship list size is 1", 1, 2, 0);
        this.UpdateItemEToDeleteRelationshipToC(itemE, itemB, itemF, col1, "TestItemE");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + itemE.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.assertItemERelationships(itemB, itemE, itemF);
        this.updateArticleItemToAddAnotherRelationship(col1, article, itemB, itemC, itemF);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + article.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.assertArticleRelationships(article, itemB, itemC, itemF);
    }

    private void assertItemERelationships(Item itemB, Item itemE, Item itemF) throws SQLException {
        List relationshipsForItemE = this.relationshipService.findByItem(this.context, itemE);
        Assert.assertThat((Object)relationshipsForItemE.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Relationship)relationshipsForItemE.get(0)).getRightItem(), (Matcher)Matchers.is((Object)itemF));
        Assert.assertThat((Object)((Relationship)relationshipsForItemE.get(1)).getRightItem(), (Matcher)Matchers.is((Object)itemB));
    }

    private void assertArticleRelationships(Item article, Item itemB, Item itemC, Item itemF) throws SQLException {
        List relationshipsForArticle = this.relationshipService.findByItemAndRelationshipType(this.context, article, this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor"));
        Assert.assertThat((Object)relationshipsForArticle.size(), (Matcher)Matchers.is((Object)3));
        ArrayList<Item> expectedRelationshipsItemsForArticle = new ArrayList<Item>();
        expectedRelationshipsItemsForArticle.add(itemC);
        expectedRelationshipsItemsForArticle.add(itemF);
        expectedRelationshipsItemsForArticle.add(itemB);
        ArrayList<Item> actualRelationshipsItemsForArticle = new ArrayList<Item>();
        for (Relationship relationship : relationshipsForArticle) {
            if (relationship.getLeftItem().getID() == article.getID()) {
                actualRelationshipsItemsForArticle.add(relationship.getLeftItem());
                continue;
            }
            actualRelationshipsItemsForArticle.add(relationship.getRightItem());
        }
        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)actualRelationshipsItemsForArticle.containsAll(expectedRelationshipsItemsForArticle)));
    }

    private void updateArticleItemToAddAnotherRelationship(Collection col1, Item article, Item itemB, Item itemC, Item itemF) throws Exception {
        String csvLineString = article.getID().toString() + "," + col1.getHandle() + ",Article,Publication," + itemB.getID().toString() + "||" + itemC.getID().toString() + "||" + itemF.getID().toString();
        String[] csv = new String[]{"id,collection,dc.title,relationship.type,relation.isAuthorOfPublication", csvLineString};
        this.performImportScript(csv);
    }

    private void UpdateItemEToDeleteRelationshipToC(Item itemE, Item itemB, Item itemF, Collection owningCollection, String title) throws Exception {
        String csvLineString = itemE.getID().toString() + "," + owningCollection.getHandle() + "," + title + ",Person," + itemB.getID().toString() + "||" + itemF.getID().toString();
        String[] csv = new String[]{"id,collection,dc.title,relationship.type,relation.isAuthorOfPublication", csvLineString};
        this.performImportScript(csv);
    }

    private Item validateSpecificItemRelationCreationCsvImport(Collection col1, Item relatedItem, String itemTitle, String relationshipType, String relationshipTypeLabel, String reasonAssertCheck, Integer sizeToCheck, Integer leftPlaceToCheck, Integer rightPlaceToCheck) throws Exception {
        String csvLineString = "+," + col1.getHandle() + "," + itemTitle + "," + relationshipType + "," + relatedItem.getID().toString();
        String[] csv = new String[]{"id,collection,dc.title,relationship.type,relation." + relationshipTypeLabel, csvLineString};
        this.performImportScript(csv);
        Iterator itemIteratorItem = this.itemService.findByMetadataField(this.context, "dc", "title", null, itemTitle);
        Item item = (Item)itemIteratorItem.next();
        List relationships = this.relationshipService.findByItem(this.context, item);
        Assert.assertThat((String)reasonAssertCheck, (Object)relationships.size(), (Matcher)Matchers.equalTo((Object)sizeToCheck));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/relationships/" + ((Relationship)relationships.get(0)).getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.leftPlace", (Matcher)Matchers.is((Object)leftPlaceToCheck))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rightPlace", (Matcher)Matchers.is((Object)rightPlaceToCheck))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RelationshipMatcher.matchRelationship((Relationship)relationships.get(0)))));
        return item;
    }

    private Item validateSpecificItemRelationCreationCsvImportMultiple(Collection col1, String itemTitle, String relationshipType, String relationshipTypeLabel, String reasonAssertCheck, Integer sizeToCheck, Integer leftPlaceToCheck, Integer rightPlaceToCheck, Item ... relatedItem) throws Exception {
        Item item2;
        Object idStringRelatedItems = "";
        for (Item item2 : relatedItem) {
            idStringRelatedItems = (String)idStringRelatedItems + item2.getID().toString();
            idStringRelatedItems = (String)idStringRelatedItems + "||";
        }
        idStringRelatedItems = ((String)idStringRelatedItems).substring(0, ((String)idStringRelatedItems).length() - 2);
        String csvLineString = "+," + col1.getHandle() + "," + itemTitle + "," + relationshipType + "," + (String)idStringRelatedItems;
        String[] csv = new String[]{"id,collection,dc.title,relationship.type,relation." + relationshipTypeLabel, csvLineString};
        this.performImportScript(csv);
        Iterator itemIteratorItem = this.itemService.findByMetadataField(this.context, "dc", "title", null, itemTitle);
        item2 = (Item)itemIteratorItem.next();
        return item2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImportScript(String[] csv) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(String.join((CharSequence)System.lineSeparator(), Arrays.asList(csv)).getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.csv", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-f", "test.csv"));
        parameters.add(new DSpaceCommandLineParameter("-s", ""));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/system/scripts/metadata-import/processes", (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            String string = "";
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void csvImportWithSpecifiedEPersonParameterTestShouldFailProcess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("OrgUnits").build();
        Item article = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Article").withIssueDate("2017-10-17").withRelationshipType("Publication").build();
        String csvLineString = "+," + col1.getHandle() + ",TestItemB,Person," + article.getID().toString();
        String[] csv = new String[]{"id,collection,dc.title,relationship.type,relation.isPublicationOfAuthor", csvLineString};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(String.join((CharSequence)System.lineSeparator(), Arrays.asList(csv)).getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.csv", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-f", "test.csv"));
        parameters.add(new DSpaceCommandLineParameter("-s", ""));
        parameters.add(new DSpaceCommandLineParameter("-e", "dspace@dspace.com"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.fileUpload((String)"/api/system/scripts/metadata-import/processes", (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new Gson().toJson(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(ProcessMatcher.matchProcess("metadata-import", String.valueOf(this.admin.getID()), parameters, ProcessStatus.FAILED)))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
        Iterator itemIteratorItem = this.itemService.findByMetadataField(this.context, "dc", "title", null, "TestItemB");
        Assert.assertFalse((boolean)itemIteratorItem.hasNext());
    }
}

