/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.authorization.Authorization;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class AuthorizationMatcher {
    private AuthorizationMatcher() {
    }

    public static Matcher matchAuthorization(Authorization authz) {
        return Matchers.allOf(AuthorizationMatcher.matchProperties(authz), AuthorizationMatcher.matchLinks(authz));
    }

    public static Matcher<? super Object> matchProperties(Authorization authz) {
        if (authz != null) {
            return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)authz.getID())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")));
        }
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")));
    }

    public static Matcher<? super Object> matchLinks(Authorization authz) {
        if (authz != null) {
            return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.is((Object)("http://localhost/api/authz/authorizations/" + authz.getID()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.feature.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.object.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")));
        }
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href"), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.eperson.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.feature.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.object.href", (Matcher)Matchers.startsWith((String)"http://localhost/api/")));
    }
}

